/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.network;

import java.util.UUID;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SelectFamiliarPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SelectFamiliarPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"select_familiar"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SelectFamiliarPacket> STREAM_CODEC = CustomPacketPayload.codec(SelectFamiliarPacket::write, SelectFamiliarPacket::new);
    private final UUID familiarId;

    public SelectFamiliarPacket(UUID familiarId) {
        this.familiarId = familiarId;
    }

    public SelectFamiliarPacket(FriendlyByteBuf buf) {
        this.familiarId = buf.readUUID();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.familiarId);
    }

    public static void handle(SelectFamiliarPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                FamiliarManager.handleFamiliarSelection((ServerPlayer)serverPlayer, (UUID)packet.familiarId);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

