/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.alshanex.alshanex_familiars.util.familiars.AlshanexFamiliarManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FamiliarDeathPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<FamiliarDeathPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"familiar_death"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FamiliarDeathPacket> STREAM_CODEC = CustomPacketPayload.codec(FamiliarDeathPacket::write, FamiliarDeathPacket::new);
    private final UUID deadFamiliarId;
    private final Map<UUID, CompoundTag> remainingFamiliars;
    private final UUID newSelectedFamiliarId;
    private final UUID currentSummonedFamiliarId;
    private final CompoundTag familiarData;
    private final CompoundTag bedLinkData;

    public FamiliarDeathPacket(UUID deadFamiliarId, Map<UUID, CompoundTag> remainingFamiliars, UUID newSelectedFamiliarId, UUID currentSummonedFamiliarId, CompoundTag familiarData, CompoundTag bedLinkData) {
        this.deadFamiliarId = deadFamiliarId;
        this.remainingFamiliars = remainingFamiliars;
        this.newSelectedFamiliarId = newSelectedFamiliarId;
        this.currentSummonedFamiliarId = currentSummonedFamiliarId;
        this.familiarData = familiarData;
        this.bedLinkData = bedLinkData;
    }

    public FamiliarDeathPacket(FriendlyByteBuf buf) {
        this.deadFamiliarId = buf.readUUID();
        int size = buf.readVarInt();
        this.remainingFamiliars = new HashMap<UUID, CompoundTag>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.readUUID();
            CompoundTag nbt = buf.readNbt();
            this.remainingFamiliars.put(id, nbt);
        }
        this.newSelectedFamiliarId = buf.readBoolean() ? buf.readUUID() : null;
        this.currentSummonedFamiliarId = buf.readBoolean() ? buf.readUUID() : null;
        this.familiarData = buf.readNbt();
        this.bedLinkData = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.deadFamiliarId);
        buf.writeVarInt(this.remainingFamiliars.size());
        for (Map.Entry<UUID, CompoundTag> entry : this.remainingFamiliars.entrySet()) {
            buf.writeUUID(entry.getKey());
            buf.writeNbt((Tag)entry.getValue());
        }
        buf.writeBoolean(this.newSelectedFamiliarId != null);
        if (this.newSelectedFamiliarId != null) {
            buf.writeUUID(this.newSelectedFamiliarId);
        }
        buf.writeBoolean(this.currentSummonedFamiliarId != null);
        if (this.currentSummonedFamiliarId != null) {
            buf.writeUUID(this.currentSummonedFamiliarId);
        }
        buf.writeNbt((Tag)this.familiarData);
        buf.writeNbt((Tag)this.bedLinkData);
    }

    public static void handle(FamiliarDeathPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> AlshanexFamiliarManager.handleFamiliarDeathPacket(packet.deadFamiliarId, packet.remainingFamiliars, packet.newSelectedFamiliarId, packet.currentSummonedFamiliarId, packet.familiarData, packet.bedLinkData));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

