/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.mixin;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.spells.holy.CleanseSpell;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.ClericPetEntity;
import net.alshanex.alshanex_familiars.entity.NecromancerPetEntity;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.familiarslib.entity.AbstractTerrestrianSpellCastingPet;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={CleanseSpell.class})
public abstract class CleanseSpellMixin
extends AbstractSpell {
    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)entity.getBoundingBox().getCenter(), (double)6.0, (double)6.0, (double)6.0)).forEach(livingEntity -> {
            NecromancerPetEntity pet;
            if (livingEntity instanceof NecromancerPetEntity && (pet = (NecromancerPetEntity)((Object)livingEntity)).getSummoner() == null) {
                ClericPetEntity cleric = new ClericPetEntity((EntityType<? extends AbstractTerrestrianSpellCastingPet>)((EntityType)EntityRegistry.CLERIC_PET.get()), pet.level());
                cleric.setPos(pet.getX(), pet.getY(), pet.getZ());
                cleric.setYRot(pet.getYRot());
                pet.level().addFreshEntity((Entity)cleric);
                MagicManager.spawnParticles((Level)pet.level(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.HOLY.get()).getTargetingColor(), 2.0f), (double)pet.getX(), (double)(pet.getY() + (double)0.165f), (double)pet.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                pet.remove(Entity.RemovalReason.DISCARDED);
            }
            IronsSpellbooks.LOGGER.debug("cleanse: {}", livingEntity);
            if (Utils.shouldHealEntity((LivingEntity)entity, (LivingEntity)livingEntity)) {
                List<Holder> effects = livingEntity.getActiveEffects().stream().map(MobEffectInstance::getEffect).filter(effect -> ((MobEffect)effect.value()).getCategory() == MobEffectCategory.HARMFUL && !effect.is(ModTags.CLEANSE_IMMUNE)).toList();
                effects.forEach(arg_0 -> ((LivingEntity)livingEntity).removeEffect(arg_0));
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.CLEANSE_PARTICLE, (double)livingEntity.getX(), (double)(livingEntity.getY() + 0.25), (double)livingEntity.getZ(), (int)15, (double)((double)livingEntity.getBbWidth() * 0.5), (double)((double)livingEntity.getBbWidth() * 0.5), (double)((double)livingEntity.getBbWidth() * 0.5), (double)0.0, (boolean)false);
            }
        });
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }
}

