/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item.curios;

import io.redspace.ironsspellbooks.compat.Curios;
import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.util.CurioUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class InvisibilityCurio
extends SimpleDescriptiveCurio {
    public InvisibilityCurio(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON), Curios.RING_SLOT);
    }

    private void handleInvisibility(SlotContext slotContext) {
        LivingEntity entity = slotContext.entity();
        if (entity != null && !slotContext.entity().level.isClientSide && CurioUtils.isWearingCurio((LivingEntity)slotContext.entity(), (Item)((Item)ItemRegistry.INVISIBILITY_CURIO.get()))) {
            this.addInvisibility(slotContext.entity().level, slotContext.entity());
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        if (slotContext.entity().tickCount % 5 == 0) {
            this.handleInvisibility(slotContext);
        }
    }

    private void addInvisibility(Level level, LivingEntity player) {
        List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(20.0), entity -> {
            AbstractSpellCastingPet pet;
            return entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().is((Entity)player);
        });
        for (Entity entity2 : entities) {
            AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity2;
            if (!(pet.getHealth() <= pet.getMaxHealth() / 4.0f)) continue;
            pet.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 7, 0, false, false, true));
        }
    }
}

