/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item.curios;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.compat.Curios;
import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import java.util.List;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.util.CurioUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;

public class HealingCurio
extends SimpleDescriptiveCurio {
    public HealingCurio(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON), Curios.RING_SLOT);
    }

    private void handleHeal(SlotContext slotContext) {
        LivingEntity entity = slotContext.entity();
        if (entity != null && !slotContext.entity().level.isClientSide && CurioUtils.isWearingCurio((LivingEntity)slotContext.entity(), (Item)((Item)ItemRegistry.HEALING_CURIO.get()))) {
            this.healPets(slotContext.entity().level, slotContext.entity());
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        if (slotContext.entity().tickCount % 10 == 0) {
            this.handleHeal(slotContext);
        }
    }

    private void healPets(Level level, LivingEntity player) {
        List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(20.0), entity -> {
            AbstractSpellCastingPet pet;
            return entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().is((Entity)player);
        });
        for (Entity entity2 : entities) {
            ServerPlayer serverPlayer;
            MagicData magicData;
            AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity2;
            if (!(pet.getHealth() < pet.getMaxHealth()) || !(player instanceof ServerPlayer) || !((magicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)player))).getMana() >= 5.0f)) continue;
            float newMana = Math.max(magicData.getMana() - 5.0f, 0.0f);
            magicData.setMana(newMana);
            pet.heal(1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

