/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import java.util.UUID;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class TinyTotem
extends Item {
    public TinyTotem() {
        super(ItemPropertiesHelper.equipment().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        AbstractSpellCastingPet pet;
        if (!this.isValidPet(target)) {
            return InteractionResult.FAIL;
        }
        if (target instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)target).getTotem().booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (!this.bind(stack, target, playerIn)) {
            return InteractionResult.FAIL;
        }
        playerIn.swing(hand);
        playerIn.setItemInHand(hand, stack);
        return InteractionResult.SUCCESS;
    }

    protected boolean isValidPet(LivingEntity target) {
        return target instanceof AbstractSpellCastingPet;
    }

    public boolean bind(ItemStack stack, LivingEntity target, Player player) {
        AbstractSpellCastingPet pet;
        if (target.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (!(target instanceof AbstractSpellCastingPet) || (pet = (AbstractSpellCastingPet)target).getSummoner() == null || !pet.getSummoner().is((Entity)player)) {
            return false;
        }
        if (stack.has(DataComponentRegistry.SOUL_LINK)) {
            CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.SOUL_LINK);
            UUID petUUID = nbt.getUUID("petUUID");
            stack.remove(DataComponentRegistry.SOUL_LINK);
            if (!target.getUUID().equals(petUUID)) {
                CompoundTag nbtSwap = new CompoundTag();
                nbtSwap.putUUID("petUUID", target.getUUID());
                if (target.hasCustomName()) {
                    nbtSwap.putString("name", target.getCustomName().getString());
                }
                nbtSwap.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
                target.saveWithoutId(nbtSwap);
                stack.set(DataComponentRegistry.SOUL_LINK, (Object)nbtSwap);
            }
            if (target instanceof AbstractSpellCastingPet) {
                AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)target;
                familiar.setTotem(Boolean.valueOf(true));
            }
            return true;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("petUUID", target.getUUID());
        if (target.hasCustomName()) {
            nbt.putString("name", target.getCustomName().getString());
        }
        nbt.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
        target.saveWithoutId(nbt);
        stack.set(DataComponentRegistry.SOUL_LINK, (Object)nbt);
        if (target instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)target;
            familiar.setTotem(Boolean.valueOf(true));
        }
        return true;
    }

    public String getID(ItemStack stack) {
        CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.SOUL_LINK);
        if (nbt.contains("name")) {
            return nbt.getString("name");
        }
        return nbt.getString("entity");
    }

    public Component getName(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return Component.translatable((String)super.getDescriptionId(stack));
        }
        return Component.translatable((String)super.getDescriptionId(stack)).append(" (" + this.getID(stack) + ")");
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.isEmpty() && stack.has(DataComponentRegistry.SOUL_LINK);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.alshanex_familiars.tiny_totem").withStyle(ChatFormatting.WHITE));
    }
}

