/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.alshanex.alshanex_familiars.util.familiars.SelectedFamiliarsComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class PandoraBox
extends CurioBaseItem {
    public PandoraBox(Item.Properties properties) {
        super(properties);
    }

    public static Set<UUID> getSelectedFamiliars(ItemStack itemStack) {
        SelectedFamiliarsComponent component = (SelectedFamiliarsComponent)itemStack.get(DataComponentRegistry.SELECTED_FAMILIARS.get());
        return component != null ? component.getSelectedFamiliars() : Set.of();
    }

    public static void setSelectedFamiliars(ItemStack itemStack, Set<UUID> familiars) {
        itemStack.set(DataComponentRegistry.SELECTED_FAMILIARS.get(), (Object)new SelectedFamiliarsComponent(familiars));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.alshanex_familiars.pandora_box.line1").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.empty());
        Set<UUID> selectedFamiliars = PandoraBox.getSelectedFamiliars(stack);
        if (!selectedFamiliars.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.alshanex_familiars.pandora_box.selected", (Object[])new Object[]{selectedFamiliars.size()}).withStyle(ChatFormatting.GOLD));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.alshanex_familiars.pandora_box.none_selected").withStyle(ChatFormatting.RED));
        }
    }
}

