/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import net.alshanex.alshanex_familiars.entity.misc.MemoryFragmentEntity;
import net.alshanex.alshanex_familiars.util.AFStructureTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class MemoryFragment
extends Item {
    public MemoryFragment() {
        super(new Item.Properties().stacksTo(16).rarity(Rarity.UNCOMMON));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 0;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ServerLevel serverlevel;
        BlockPos blockpos;
        ItemStack fragment = player.getItemInHand(hand);
        player.startUsingItem(hand);
        if (level instanceof ServerLevel && (blockpos = (serverlevel = (ServerLevel)level).findNearestMapStructure(AFStructureTags.MEMORY_FRAGMENT_LOCATED, player.blockPosition(), 100, false)) != null) {
            MemoryFragmentEntity memoryFragment = new MemoryFragmentEntity(level, player.getX(), player.getY(0.5), player.getZ());
            memoryFragment.signalTo(blockpos);
            level.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, memoryFragment.position(), GameEvent.Context.of((Entity)player));
            level.addFreshEntity((Entity)memoryFragment);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                CriteriaTriggers.USED_ENDER_EYE.trigger(serverplayer, blockpos);
            }
            float f = Mth.lerp((float)level.random.nextFloat(), (float)0.33f, (float)0.5f);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 1.0f, f);
            fragment.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.swing(hand, true);
            return InteractionResultHolder.success((Object)fragment);
        }
        return InteractionResultHolder.consume((Object)fragment);
    }
}

