/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.event;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="alshanex_familiars")
public class PlayerLoginHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AlshanexFamiliarsMod.LOGGER.info("Player {} logged in, syncing familiar and bed link data", (Object)serverPlayer.getName().getString());
            PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            BedLinkData bedLinkData = (BedLinkData)serverPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
            AlshanexFamiliarsMod.LOGGER.info("Player has {} familiars and {} bed links", (Object)familiarData.getFamiliarCount(), (Object)bedLinkData.getAllLinks().size());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newPlayer = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer oldPlayer = (ServerPlayer)player;
                AlshanexFamiliarsMod.LOGGER.info("Player {} cloned (death: {}), copying familiar and bed link data", (Object)newPlayer.getName().getString(), (Object)event.isWasDeath());
                PlayerFamiliarData oldFamiliarData = (PlayerFamiliarData)oldPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
                PlayerFamiliarData newFamiliarData = (PlayerFamiliarData)newPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
                BedLinkData oldBedLinkData = (BedLinkData)oldPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
                BedLinkData newBedLinkData = (BedLinkData)newPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
                try {
                    CompoundTag oldFamiliarNBT = oldFamiliarData.serializeNBT((HolderLookup.Provider)oldPlayer.registryAccess());
                    newFamiliarData.deserializeNBT((HolderLookup.Provider)newPlayer.registryAccess(), oldFamiliarNBT);
                    CompoundTag oldBedLinkNBT = oldBedLinkData.serializeNBT((HolderLookup.Provider)oldPlayer.registryAccess());
                    newBedLinkData.deserializeNBT((HolderLookup.Provider)newPlayer.registryAccess(), oldBedLinkNBT);
                    AlshanexFamiliarsMod.LOGGER.info("Successfully copied {} familiars and {} bed links to new player", (Object)newFamiliarData.getFamiliarCount(), (Object)newBedLinkData.getAllLinks().size());
                }
                catch (Exception e) {
                    AlshanexFamiliarsMod.LOGGER.error("Error copying player data during clone: ", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            AlshanexFamiliarsMod.LOGGER.debug("Player {} died, desummoning all familiars", (Object)serverPlayer.getName().getString());
            ServerLevel level = serverPlayer.serverLevel();
            Map familiars = familiarData.getAllFamiliars();
            Set familiarUUIDs = familiars.keySet();
            familiarData.clearAllSummoned();
            for (UUID familiarUUID : familiarUUIDs) {
                Entity existingEntity = level.getEntity(familiarUUID);
                boolean familiarExistsInWorld = existingEntity instanceof AbstractSpellCastingPet;
                if (!familiarExistsInWorld) continue;
                if (existingEntity instanceof AbstractSpellCastingPet) {
                    AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)existingEntity;
                    if (familiar.isCasting()) {
                        familiar.cancelCast();
                        familiar.getMagicData().resetCastingState();
                    }
                    familiar.setTarget(null);
                    familiar.setHasUsedSingleAttack(false);
                    CompoundTag updatedNBT = FamiliarManager.createFamiliarNBT((AbstractSpellCastingPet)familiar);
                    familiarData.addTamedFamiliar(familiarUUID, updatedNBT);
                    familiar.remove(Entity.RemovalReason.DISCARDED);
                    level.playSound(null, familiar.getX(), familiar.getY(), familiar.getZ(), SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    AlshanexFamiliarsMod.LOGGER.debug("Familiar desummoned due to player death: {}", (Object)familiarUUID);
                    continue;
                }
                AlshanexFamiliarsMod.LOGGER.debug("Familiar not found in world: {}", (Object)familiarUUID);
            }
            FamiliarManager.syncFamiliarDataForPlayer((ServerPlayer)serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            AlshanexFamiliarsMod.LOGGER.debug("Player {} changed dimension, syncing familiar and bed link data", (Object)serverPlayer.getName().getString());
            if (!serverPlayer.level.isClientSide) {
                ServerLevel originalLevel = serverPlayer.server.getLevel(event.getFrom());
                Map familiars = familiarData.getAllFamiliars();
                Set familiarUUIDS = familiars.keySet();
                familiarData.clearAllSummoned();
                for (UUID familiarUUID : familiarUUIDS) {
                    Entity existingEntity = originalLevel.getEntity(familiarUUID);
                    boolean familiarExistsInWorld = existingEntity instanceof AbstractSpellCastingPet;
                    if (!familiarExistsInWorld) continue;
                    if (existingEntity instanceof AbstractSpellCastingPet) {
                        AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)existingEntity;
                        if (familiar.isCasting()) {
                            familiar.cancelCast();
                            familiar.getMagicData().resetCastingState();
                        }
                        familiar.setTarget(null);
                        familiar.setHasUsedSingleAttack(false);
                        CompoundTag updatedNBT = FamiliarManager.createFamiliarNBT((AbstractSpellCastingPet)familiar);
                        familiarData.addTamedFamiliar(familiarUUID, updatedNBT);
                        familiar.remove(Entity.RemovalReason.DISCARDED);
                        originalLevel.playSound(null, familiar.getX(), familiar.getY(), familiar.getZ(), SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        AlshanexFamiliarsMod.LOGGER.debug("Specific familiar desummoned successfully: {}", (Object)familiarUUID);
                        continue;
                    }
                    AlshanexFamiliarsMod.LOGGER.debug("Familiar not found in world: {}", (Object)familiarUUID);
                }
                FamiliarManager.syncFamiliarDataForPlayer((ServerPlayer)serverPlayer);
            }
        }
    }
}

