/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.event;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.item.TinyTotem;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.alshanex.alshanex_familiars.util.familiars.AlshanexFamiliarManager;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.util.familiars.FamiliarAdvancementsHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="alshanex_familiars")
public class FamiliarDeathEventHandler {
    private static final Set<UUID> processedDeaths = new HashSet<UUID>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractSpellCastingPet) {
            LivingEntity livingEntity2;
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)livingEntity;
            if (familiar.getSummoner() != null && (livingEntity2 = familiar.getSummoner()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                if (FamiliarAdvancementsHelper.hasRevivalAdvancement((ServerPlayer)serverPlayer)) {
                    AlshanexFamiliarsMod.LOGGER.info("Player {} has revival advancement", (Object)serverPlayer.getName().getString());
                    MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                    if (magicData.getMana() >= 80.0f) {
                        familiar.setHealth(familiar.getMaxHealth() / 2.0f);
                        float newMana = Math.max(magicData.getMana() - 80.0f, 0.0f);
                        magicData.setMana(newMana);
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        event.setCanceled(true);
                        return;
                    }
                    ItemStack boundSoulLink = FamiliarDeathEventHandler.findBoundSoulLink((Player)serverPlayer, familiar);
                    if (boundSoulLink != null) {
                        AlshanexFamiliarsMod.LOGGER.debug("Found Tiny Totem, reviving familiar");
                        familiar.setHealth(familiar.getMaxHealth() / 2.0f);
                        event.setCanceled(true);
                        boundSoulLink.shrink(1);
                        familiar.setTotem(Boolean.valueOf(false));
                        FamiliarDeathEventHandler.triggerTotem(familiar);
                        return;
                    }
                } else {
                    AlshanexFamiliarsMod.LOGGER.debug("Player {} does not have revival advancement", (Object)serverPlayer.getName().getString());
                    ItemStack boundSoulLink = FamiliarDeathEventHandler.findBoundSoulLink((Player)serverPlayer, familiar);
                    if (boundSoulLink != null) {
                        AlshanexFamiliarsMod.LOGGER.debug("Found Tiny Totem, reviving familiar");
                        familiar.setHealth(familiar.getMaxHealth() / 2.0f);
                        event.setCanceled(true);
                        boundSoulLink.shrink(1);
                        familiar.setTotem(Boolean.valueOf(false));
                        FamiliarDeathEventHandler.triggerTotem(familiar);
                        return;
                    }
                }
            }
            FamiliarDeathEventHandler.handleDeath(familiar);
        }
    }

    private static void triggerTotem(AbstractSpellCastingPet pet) {
        pet.removeEffectsCuredBy(EffectCures.PROTECTED_BY_TOTEM);
        pet.level().broadcastEntityEvent((Entity)pet, (byte)35);
    }

    private static ItemStack findBoundSoulLink(Player player, AbstractSpellCastingPet pet) {
        for (ItemStack stack : player.getInventory().items) {
            if (!FamiliarDeathEventHandler.isSoulLinkBoundToPet(stack, pet)) continue;
            return stack;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            stack = player.getInventory().getItem(i);
            if (!FamiliarDeathEventHandler.isSoulLinkBoundToPet(stack, pet)) continue;
            return stack;
        }
        for (ItemStack stack : player.getInventory().armor) {
            if (!FamiliarDeathEventHandler.isSoulLinkBoundToPet(stack, pet)) continue;
            return stack;
        }
        ItemStack offhandStack = (ItemStack)player.getInventory().offhand.get(0);
        if (FamiliarDeathEventHandler.isSoulLinkBoundToPet(offhandStack, pet)) {
            return offhandStack;
        }
        return null;
    }

    private static boolean isSoulLinkBoundToPet(ItemStack stack, AbstractSpellCastingPet pet) {
        Item item = stack.getItem();
        if (!(item instanceof TinyTotem)) {
            return false;
        }
        TinyTotem tinyTotem = (TinyTotem)item;
        if (!tinyTotem.containsEntity(stack)) {
            return false;
        }
        CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.SOUL_LINK);
        if (nbt == null || !nbt.contains("petUUID")) {
            return false;
        }
        return nbt.getUUID("petUUID").equals(pet.getUUID());
    }

    private static void handleDeath(AbstractSpellCastingPet familiar) {
        UUID familiarId = familiar.getUUID();
        if (processedDeaths.contains(familiarId)) {
            AlshanexFamiliarsMod.LOGGER.debug("Death already processed for familiar {}", (Object)familiarId);
            return;
        }
        AlshanexFamiliarsMod.LOGGER.info("Processing death event for familiar {} with health {} (BEFORE die() method)", (Object)familiarId, (Object)Float.valueOf(familiar.getHealth()));
        processedDeaths.add(familiarId);
        LivingEntity livingEntity = familiar.getSummoner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            AlshanexFamiliarsMod.LOGGER.info("Found owner {} for dying familiar {}", (Object)serverPlayer.getName().getString(), (Object)familiarId);
            try {
                AlshanexFamiliarManager.handleFamiliarDeath(familiar, serverPlayer);
                AlshanexFamiliarsMod.LOGGER.info("Successfully processed death for familiar {} - death packet sent", (Object)familiarId);
            }
            catch (Exception e) {
                AlshanexFamiliarsMod.LOGGER.error("Error processing death for familiar {}: ", (Object)familiarId, (Object)e);
            }
        } else {
            AlshanexFamiliarsMod.LOGGER.warn("Dying familiar {} has no valid owner", (Object)familiarId);
        }
        familiar.level().getServer().execute(() -> familiar.level().getServer().execute(() -> {
            processedDeaths.remove(familiarId);
            AlshanexFamiliarsMod.LOGGER.debug("Cleaned up processed death entry for familiar {}", (Object)familiarId);
        }));
    }

    public static void clearProcessedDeaths() {
        processedDeaths.clear();
        AlshanexFamiliarsMod.LOGGER.debug("Cleared all processed deaths");
    }

    public static boolean wasDeathProcessed(UUID familiarId) {
        return processedDeaths.contains(familiarId);
    }

    public static int getProcessedDeathsCount() {
        return processedDeaths.size();
    }
}

