/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.event;

import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.datafix.DataFixerHelpers;
import net.alshanex.alshanex_familiars.datafix.DataFixerStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="alshanex_familiars")
public class DataFixerEvents {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (DataFixerStorage.INSTANCE != null && DataFixerStorage.INSTANCE.needsUpgrade()) {
            AlshanexFamiliarsMod.LOGGER.debug("Familiars: Initializing data migration " + DataFixerStorage.INSTANCE.getDataVersion() + " a 1");
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (DataFixerStorage.INSTANCE == null || !DataFixerStorage.INSTANCE.needsUpgrade()) {
            return;
        }
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        chunk.getBlockEntities().forEach((pos, blockEntity) -> {
            RegistryAccess registryAccess = event.getLevel().registryAccess();
            CompoundTag blockEntityTag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)registryAccess);
            if (DataFixerHelpers.doFixUps(blockEntityTag)) {
                blockEntity.loadWithComponents(blockEntityTag, (HolderLookup.Provider)registryAccess);
                blockEntity.setChanged();
            }
        });
        AlshanexFamiliarsMod.LOGGER.debug("Familiars: Processed data migration in chunks");
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (DataFixerStorage.INSTANCE == null || !DataFixerStorage.INSTANCE.needsUpgrade()) {
            return;
        }
        DataFixerEvents.fixEntity(event.getEntity());
        AlshanexFamiliarsMod.LOGGER.debug("Familiars: Migrated data from entity " + String.valueOf(event.getEntity()));
    }

    private static void fixEntity(Entity entity) {
        RegistryAccess registryAccess = entity.level().registryAccess();
        CompoundTag entityTag = new CompoundTag();
        entity.save(entityTag);
        if (DataFixerHelpers.doFixUps(entityTag)) {
            entity.load(entityTag);
        }
    }
}

