/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.sound;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.alshanex.familiarslib.util.CylinderParticleManager;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ExplosionEvent;

public class HarpExplosionEntity
extends AoeEntity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int age;
    private float damage;

    public HarpExplosionEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public HarpExplosionEntity(Level level, LivingEntity owner, float damage) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.HARP_EXPLOSION.get()), level);
        this.setOwner(owner);
        this.setDamage(damage);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            if (this.age == 1) {
                this.level.addParticle((ParticleOptions)ParticleRegistry.DESTRUCTION_SYMPHONY_PARTICLE.get(), this.getX(), this.getY() + 3.0, this.getZ(), 0.0, 0.0, 0.0);
            }
            if (this.age == 26) {
                this.level.addParticle((ParticleOptions)ParticleRegistry.HARP_EXPLOSION_PARTICLE.get(), this.getX(), this.getY() + 5.0, this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.age > 60) {
                this.discard();
            }
            if (this.age <= 20) {
                CylinderParticleManager.spawnParticlesAtBlockPos((Level)this.level(), (Vec3)this.position(), (int)50, (ParticleOptions)((ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get()), (CylinderParticleManager.ParticleDirection)CylinderParticleManager.ParticleDirection.UPWARD, (double)4.0, (double)0.0, (double)0.0);
            }
            if (this.age == 26) {
                Explosion explosion;
                float explosionRadius = 4.0f;
                float explosionRadiusSqr = explosionRadius * explosionRadius;
                List entities = this.level.getEntities((Entity)this, this.getBoundingBox().inflate((double)explosionRadius), entity -> this.getOwner() != null && !entity.is((Entity)this.getOwner()) && !this.getOwner().isAlliedTo(entity));
                Vec3 losPoint = Utils.raycastForBlock((Level)this.level, (Vec3)this.position(), (Vec3)this.position().add(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation();
                for (Entity entity2 : entities) {
                    double distanceSqr = entity2.distanceToSqr(this.position());
                    if (!(distanceSqr < (double)explosionRadiusSqr) || !Utils.hasLineOfSight((Level)this.level, (Vec3)losPoint, (Vec3)entity2.getBoundingBox().getCenter(), (boolean)true)) continue;
                    double p = 1.0 - distanceSqr / (double)explosionRadiusSqr;
                    float damage = (float)((double)this.damage * p);
                    DamageSources.applyDamage((Entity)entity2, (float)damage, (DamageSource)PetSpellRegistry.EXPLOSION_MELODY.get().getDamageSource((Entity)this, (Entity)this.getOwner()));
                    if (!(entity2 instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity2;
                    target.addDeltaMovement(new Vec3(0.0, 1.0, 0.0));
                    target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 50, 3, false, false));
                    target.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 50, 3, false, false));
                    target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 50, 3, false, false));
                }
                if (((Boolean)ServerConfigs.SPELL_GREIFING.get()).booleanValue() && !((ExplosionEvent.Start)NeoForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(this.level, explosion = new Explosion(this.level, null, (DamageSource)PetSpellRegistry.EXPLOSION_MELODY.get().getDamageSource((Entity)this, (Entity)this.getOwner()), null, this.getX(), this.getY(), this.getZ(), 4.0f, true, Explosion.BlockInteraction.DESTROY, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE)))).isCanceled()) {
                    explosion.explode();
                    explosion.finalizeExplosion(false);
                }
                this.playSound((SoundEvent)AFSoundRegistry.HARP_EXPLOSION.get(), 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f);
            }
        }
        ++this.age;
    }

    public void applyEffect(LivingEntity target) {
        if (!target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) && this.owner != null && !this.owner.isAlliedTo((Entity)target)) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 2, false, false));
        }
    }

    public float getParticleCount() {
        return 0.0f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.age = pCompound.getInt("Age");
        if (pCompound.hasUUID("Owner")) {
            this.ownerUUID = pCompound.getUUID("Owner");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Age", this.age);
        if (this.ownerUUID != null) {
            pCompound.putUUID("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level instanceof ServerLevel && (entity = ((ServerLevel)this.level).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }
}

