/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.misc;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.EffectRegistry;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlueBirdEntity
extends PathfinderMob
implements GeoEntity,
IMagicSummon {
    private int effectAmplifier;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    private final RawAnimation walk = RawAnimation.begin().thenLoop("walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BlueBirdEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.xpReward = 0;
    }

    public BlueBirdEntity(Level level, int effectAmplifier) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntityRegistry.BLUE_BIRD.get()), level);
        this.effectAmplifier = effectAmplifier;
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new BuffAllyGoal(this, () -> ((BlueBirdEntity)this).getSummoner(), this.effectAmplifier));
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, () -> ((BlueBirdEntity)this).getSummoner(), (double)0.9f, 10.0f, 3.0f, false, 25.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new FlyingBirdWanderGoal(this, this, 60));
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public void travel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.FLYING_SPEED, (double)0.15f).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public boolean isAlliedTo(Entity pEntity) {
        return super.isAlliedTo(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
    }

    public void tick() {
        super.tick();
        Entity summoner = SummonManager.getOwner((Entity)this);
        if (summoner != null && summoner instanceof LivingEntity) {
            LivingEntity livingSummoner = (LivingEntity)summoner;
            if (this.tickCount % 5 == 0) {
                if (livingSummoner.hasEffect((Holder)MobEffectRegistry.HASTENED)) {
                    if (livingSummoner.getEffect((Holder)MobEffectRegistry.HASTENED).getDuration() < 500) {
                        livingSummoner.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.HASTENED, 500 - livingSummoner.getEffect((Holder)MobEffectRegistry.HASTENED).getDuration(), Math.max(0, this.effectAmplifier - 1), false, false, true));
                    }
                } else {
                    livingSummoner.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.HASTENED, 500, Math.max(0, this.effectAmplifier - 1), false, false, true));
                }
                if (livingSummoner.hasEffect(EffectRegistry.BIRD_BUFF)) {
                    if (livingSummoner.getEffect(EffectRegistry.BIRD_BUFF).getDuration() < 500) {
                        livingSummoner.addEffect(new MobEffectInstance(EffectRegistry.BIRD_BUFF, 500 - livingSummoner.getEffect(EffectRegistry.BIRD_BUFF).getDuration(), 0, false, false, true));
                    }
                } else {
                    livingSummoner.addEffect(new MobEffectInstance(EffectRegistry.BIRD_BUFF, 500, 0, false, false, true));
                }
            }
        }
    }

    public void die(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.die(pDamageSource);
    }

    public void onRemovedFromLevel() {
        this.onRemovedHelper((Entity)this);
        super.onRemovedFromLevel();
    }

    public void onUnSummon() {
        if (!this.level().isClientSide) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.POOF, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.discard();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate));
    }

    private PlayState idlePredicate(AnimationState event) {
        if (event.isMoving()) {
            event.getController().setAnimation(this.walk);
            return PlayState.CONTINUE;
        }
        if (!event.isMoving()) {
            event.getController().setAnimation(this.idle);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected class BuffAllyGoal
    extends Goal {
        private final BlueBirdEntity bird;
        private LivingEntity ally;
        private final Supplier<Entity> petOwner;
        private final int effectAmplifier;

        public BuffAllyGoal(BlueBirdEntity bird, Supplier<Entity> owner, int effectAmplifier) {
            this.bird = bird;
            this.petOwner = owner;
            this.effectAmplifier = effectAmplifier;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            Entity livingentity = this.petOwner.get();
            if (livingentity == null) {
                return false;
            }
            if (!(livingentity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity owner = (LivingEntity)livingentity;
            if (this.ally != null) {
                return false;
            }
            this.ally = this.bird.level().getEntitiesOfClass(LivingEntity.class, this.bird.getBoundingBox().inflate(15.0), livingEntity -> livingEntity != owner && Utils.shouldHealEntity((LivingEntity)owner, (LivingEntity)livingEntity) && !livingEntity.hasEffect((Holder)MobEffectRegistry.HASTENED) && !livingEntity.hasEffect(EffectRegistry.BIRD_BUFF)).stream().min(Comparator.comparingDouble(arg_0 -> ((BlueBirdEntity)this.bird).distanceTo(arg_0))).orElse(null);
            return this.ally != null;
        }

        public boolean canContinueToUse() {
            return this.ally != null && this.ally.isAlive() && !this.ally.hasEffect((Holder)MobEffectRegistry.HASTENED) && !this.ally.hasEffect(EffectRegistry.BIRD_BUFF);
        }

        public void start() {
            this.bird.getNavigation().moveTo((Entity)this.ally, 1.0);
        }

        public void tick() {
            if (this.ally == null) {
                return;
            }
            if ((double)this.bird.distanceTo((Entity)this.ally) < 3.0) {
                this.bird.getLookControl().setLookAt((Entity)this.ally, 10.0f, 10.0f);
                if (!this.ally.hasEffect((Holder)MobEffectRegistry.HASTENED)) {
                    this.ally.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.HASTENED, 300, Math.max(0, this.effectAmplifier - 1), false, false, true));
                    this.ally.addEffect(new MobEffectInstance(EffectRegistry.BIRD_BUFF, 300, 0, false, false, true));
                    if (!BlueBirdEntity.this.level().isClientSide) {
                        BlueBirdEntity.this.level().playSound(null, this.bird.getX(), this.bird.getY(), this.bird.getZ(), (SoundEvent)AFSoundRegistry.BIRD_CHIRP.get(), SoundSource.MUSIC, 1.0f, 1.0f);
                        MagicManager.spawnParticles((Level)BlueBirdEntity.this.level, (ParticleOptions)((ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get()), (double)this.bird.getX(), (double)this.bird.getY(), (double)this.bird.getZ(), (int)5, (double)0.0, (double)0.0, (double)0.0, (double)0.18, (boolean)true);
                    }
                }
            } else {
                this.bird.getNavigation().moveTo((Entity)this.ally, 1.0);
            }
        }

        public void stop() {
            this.ally = null;
        }
    }

    class FlyingBirdWanderGoal
    extends Goal {
        private static final int WANDER_THRESHOLD = 22;
        private final BlueBirdEntity bird;
        private final int interval;
        private int cooldown;

        FlyingBirdWanderGoal(BlueBirdEntity this$0, BlueBirdEntity bird, int interval) {
            this.bird = bird;
            this.interval = interval;
            this.cooldown = 0;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return this.bird.getNavigation().isDone() && this.bird.getRandom().nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return this.bird.getNavigation().isInProgress();
        }

        public void start() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                this.bird.getNavigation().moveTo(this.bird.getNavigation().createPath(BlockPos.containing((Position)vec3), 1), 1.0);
            }
            this.cooldown = this.interval;
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3;
            if (this.bird.getTarget() != null) {
                Vec3 targetPos = this.bird.getTarget().position();
                vec3 = targetPos.subtract(this.bird.position()).normalize();
            } else {
                vec3 = this.bird.getViewVector(0.0f);
            }
            int i = 8;
            Vec3 randomPos = HoverRandomPos.getPos((PathfinderMob)this.bird, (int)i, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            return randomPos != null ? randomPos : AirAndWaterRandomPos.getPos((PathfinderMob)this.bird, (int)i, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
        }
    }
}

