/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.alshanex.alshanex_familiars.util.AlshanexFamiliarsTags;
import net.alshanex.familiarslib.advancements.SimpleAdvancementTrigger;
import net.alshanex.familiarslib.entity.AbstractFlyingSpellCastingPet;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.CriteriaTriggersRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarGoals;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonerPetEntity
extends AbstractFlyingSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/summoner_pet.png");

    public SummonerPetEntity(EntityType<? extends AbstractFlyingSpellCastingPet> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.initializeAttackGoal(2);
        this.goalSelector.addGoal(3, (Goal)new FamiliarGoals.DisableSculkShriekerGoal((AbstractSpellCastingPet)this, () -> ((SummonerPetEntity)this).getSummoner(), 10));
    }

    protected WizardAttackGoal createAttackGoal(float min, float max) {
        List<AbstractSpell> attackSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.SUMMONER_ATTACK_SPELLS);
        List<AbstractSpell> defenseSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.SUMMONER_DEFENSE_SPELLS);
        List<AbstractSpell> movementSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.SUMMONER_MOVEMENT_SPELLS);
        List<AbstractSpell> supportSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.SUMMONER_SUPPORT_SPELLS);
        return new WizardAttackGoal((IMagicEntity)this, 1.0, 80, 120).setSpells(attackSpells, defenseSpells, movementSpells, supportSpells).setSingleUseSpell(PetSpellRegistry.SUMMON_SHADOW.get(), 200, 400, 1, 4).setIsFlying().setSpellQuality(min, max);
    }

    protected Item getValidTrinket() {
        return (Item)ItemRegistry.SUMMONER_TRINKET.get();
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    protected boolean isFood(ItemStack item) {
        return item.is(AlshanexFamiliarsTags.SUMMONER_FOOD);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    public void tick() {
        super.tick();
        if (this.getSummoner() != null && this.tickCount % 5 == 0 && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f) {
            if (this.getSummoner().hasEffect(MobEffects.NIGHT_VISION)) {
                if (this.getSummoner().getEffect(MobEffects.NIGHT_VISION).getDuration() < 500) {
                    this.getSummoner().addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 500 - this.getSummoner().getEffect(MobEffects.NIGHT_VISION).getDuration(), 0, false, false, true));
                }
            } else {
                this.getSummoner().addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 500, 0, false, false, true));
            }
            if (this.getSummoner().hasEffect(MobEffects.BLINDNESS)) {
                this.triggerAnim("interact_controller", "interact");
                this.getSummoner().removeEffect(MobEffects.BLINDNESS);
            }
            if (this.getSummoner().hasEffect(MobEffects.DARKNESS)) {
                this.triggerAnim("interact_controller", "interact");
                this.getSummoner().removeEffect(MobEffects.DARKNESS);
            }
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)CriteriaTriggersRegistry.TAMING_SUMMONER_TRIGGER.get()).trigger(player);
    }
}

