/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.AlshanexFamiliarsTags;
import net.alshanex.alshanex_familiars.util.familiars.AlshanexFamiliarGoals;
import net.alshanex.familiarslib.advancements.SimpleAdvancementTrigger;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.entity.AbstractTerrestrianSpellCastingPet;
import net.alshanex.familiarslib.registry.CriteriaTriggersRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarGoals;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NecromancerPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/necromancer_pet.png");

    public NecromancerPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.initializeAttackGoal(2);
        this.goalSelector.addGoal(2, (Goal)new AlshanexFamiliarGoals.UndeadChaosGoal((AbstractSpellCastingPet)this, () -> ((NecromancerPetEntity)this).getSummoner(), 10.0, 100));
        this.goalSelector.addGoal(10, (Goal)new FamiliarGoals.WitherifyGoal((AbstractSpellCastingPet)this));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
    }

    protected WizardAttackGoal createAttackGoal(float min, float max) {
        List<AbstractSpell> attackSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.NECROMANCER_ATTACK_SPELLS);
        List<AbstractSpell> defenseSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.NECROMANCER_DEFENSE_SPELLS);
        List<AbstractSpell> movementSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.NECROMANCER_MOVEMENT_SPELLS);
        List<AbstractSpell> supportSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.NECROMANCER_SUPPORT_SPELLS);
        return new WizardAttackGoal((IMagicEntity)this, 1.0, 60, 100).setSpells(attackSpells, defenseSpells, movementSpells, supportSpells).setSingleUseSpell((AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get(), 2000, 3000, 1, 4).setSpellQuality(min, max);
    }

    protected Item getValidTrinket() {
        return (Item)ItemRegistry.NECROMANCER_TRINKET.get();
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    protected boolean isFood(ItemStack item) {
        return item.is(AlshanexFamiliarsTags.NECROMANCER_FOOD);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)CriteriaTriggersRegistry.TAMING_NECROMANCER_TRIGGER.get()).trigger(player);
    }
}

