/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.AlshanexFamiliarsTags;
import net.alshanex.alshanex_familiars.util.familiars.AlshanexFamiliarGoals;
import net.alshanex.familiarslib.advancements.SimpleAdvancementTrigger;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.entity.AbstractTerrestrianSpellCastingPet;
import net.alshanex.familiarslib.registry.CriteriaTriggersRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarGoals;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IllusionistPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/illusionist_pet.png");

    public IllusionistPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.initializeAttackGoal(2);
        this.goalSelector.addGoal(2, (Goal)new AlshanexFamiliarGoals.DecoyGoal((AbstractSpellCastingPet)this, 200));
        this.goalSelector.addGoal(3, (Goal)new FamiliarGoals.StealItemsWhenNotWatchedGoal((AbstractSpellCastingPet)this, 3.0));
    }

    protected WizardAttackGoal createAttackGoal(float min, float max) {
        List<AbstractSpell> attackSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.ILLUSIONIST_ATTACK_SPELLS);
        List<AbstractSpell> defenseSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.ILLUSIONIST_DEFENSE_SPELLS);
        List<AbstractSpell> movementSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.ILLUSIONIST_MOVEMENT_SPELLS);
        List<AbstractSpell> supportSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.ILLUSIONIST_SUPPORT_SPELLS);
        return new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(attackSpells, defenseSpells, movementSpells, supportSpells).setSingleUseSpell((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get(), 2000, 3000, 1, 4).setSpellQuality(min, max);
    }

    protected Item getValidTrinket() {
        return (Item)ItemRegistry.ILLUSIONIST_TRINKET.get();
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    protected boolean isFood(ItemStack item) {
        return item.is(AlshanexFamiliarsTags.ILLUSIONIST_FOOD);
    }

    public void tick() {
        super.tick();
        if (this.getSummoner() != null && this.tickCount % 5 == 0 && (double)this.getSummoner().getHealth() < (double)this.getSummoner().getMaxHealth() * 0.25 && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f) {
            if (this.getSummoner().hasEffect((Holder)MobEffectRegistry.TRUE_INVISIBILITY)) {
                if (this.getSummoner().getEffect((Holder)MobEffectRegistry.TRUE_INVISIBILITY).getDuration() < 500) {
                    this.getSummoner().addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 500 - this.getSummoner().getEffect((Holder)MobEffectRegistry.TRUE_INVISIBILITY).getDuration(), 0, false, false, true));
                }
            } else {
                this.getSummoner().addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 500, 0, false, false, true));
            }
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)CriteriaTriggersRegistry.TAMING_ILLUSIONIST_TRIGGER.get()).trigger(player);
    }
}

