/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.AlshanexFamiliarsTags;
import net.alshanex.familiarslib.advancements.SimpleAdvancementTrigger;
import net.alshanex.familiarslib.entity.AbstractTerrestrianSpellCastingPet;
import net.alshanex.familiarslib.registry.CriteriaTriggersRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class FrostlingPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/frostling_pet.png");

    public FrostlingPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.initializeAttackGoal(2);
        this.goalSelector.addGoal(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level));
    }

    protected WizardAttackGoal createAttackGoal(float min, float max) {
        List<AbstractSpell> attackSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.FROSTLING_ATTACK_SPELLS);
        List<AbstractSpell> defenseSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.FROSTLING_DEFENSE_SPELLS);
        List<AbstractSpell> movementSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.FROSTLING_MOVEMENT_SPELLS);
        List<AbstractSpell> supportSpells = AlshanexFamiliarsTags.getSpellsFromTag(AlshanexFamiliarsTags.FROSTLING_SUPPORT_SPELLS);
        return new WizardAttackGoal((IMagicEntity)this, 1.25, 40, 60).setSpells(attackSpells, defenseSpells, movementSpells, supportSpells).setSingleUseSpell((AbstractSpell)SpellRegistry.ICE_SPIKES_SPELL.get(), 200, 300, 8, 10).setSpellQuality(min, max);
    }

    protected Item getValidTrinket() {
        return (Item)ItemRegistry.FROSTLING_TRINKET.get();
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    protected boolean isFood(ItemStack item) {
        return item.is(AlshanexFamiliarsTags.FROSTLING_FOOD);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)CriteriaTriggersRegistry.TAMING_FROSTLING_TRIGGER.get()).trigger(player);
    }

    public boolean canFreeze() {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 8 == 0) {
            if (this.getSummoner() != null && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f) {
                if (this.getSummoner().hasEffect((Holder)MobEffectRegistry.CHILLED)) {
                    this.getSummoner().removeEffect((Holder)MobEffectRegistry.CHILLED);
                }
                this.applyFrostWalkerEffect(this.getSummoner());
                this.getSummoner().setTicksFrozen(0);
                this.getSummoner().setIsInPowderSnow(false);
            }
            this.removeEffect((Holder)MobEffectRegistry.CHILLED);
            this.setTicksFrozen(0);
            this.applyFrostWalkerEffect((LivingEntity)this);
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    private void applyFrostWalkerEffect(LivingEntity entity) {
        if (entity.onGround()) {
            BlockState blockState = Blocks.FROSTED_ICE.defaultBlockState();
            float radius = 2.0f;
            BlockPos blockPos = entity.blockPosition();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-2, -1, -2), (BlockPos)blockPos.offset(2, -1, 2))) {
                BlockState currentState;
                if (!pos.closerToCenterThan((Position)entity.position(), (double)radius) || (currentState = this.level().getBlockState(pos)).getBlock() != Blocks.WATER || (Integer)currentState.getValue((Property)LiquidBlock.LEVEL) != 0 || !this.level().isEmptyBlock(pos.above()) || !currentState.canSurvive((LevelReader)this.level(), pos) || !this.level().isUnobstructed(blockState, pos, CollisionContext.empty())) continue;
                this.level().setBlockAndUpdate(pos, blockState);
                this.level().scheduleTick(pos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)this.random, (int)60, (int)120));
            }
        }
    }
}

