/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.datafix;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class DataFixerStorage
extends SavedData {
    public static DataFixerStorage INSTANCE;
    private DimensionDataStorage overworldDataStorage;
    private int dataVersion;
    private static final String DATA_NAME = "familiars_data_fixer";

    public static void init(DimensionDataStorage dataStorage) {
        INSTANCE = (DataFixerStorage)dataStorage.computeIfAbsent(new SavedData.Factory(DataFixerStorage::new, DataFixerStorage::load, null), DATA_NAME);
        DataFixerStorage.INSTANCE.overworldDataStorage = dataStorage;
    }

    public DataFixerStorage() {
        this.dataVersion = 0;
    }

    public DataFixerStorage(int dataVersion) {
        this.dataVersion = dataVersion;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(int dataVersion) {
        this.dataVersion = dataVersion;
        this.setDirty();
        if (this.overworldDataStorage != null) {
            this.overworldDataStorage.save();
        }
    }

    public boolean needsUpgrade() {
        return this.dataVersion < 1;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pCompoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        pCompoundTag.putInt("dataVersion", this.dataVersion);
        return pCompoundTag;
    }

    public static DataFixerStorage load(CompoundTag tag, HolderLookup.Provider provider) {
        int dataVersion = tag.getInt("dataVersion");
        return new DataFixerStorage(dataVersion);
    }
}

