/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block.entity;

import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import javax.annotation.Nonnull;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.alshanex.alshanex_familiars.util.rituals.RitualHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RitualCorePedestalEntity
extends BlockEntity {
    private static final String NBT_HELD_ITEM = "heldItem";
    private static final String NBT_ITEM_IN_RECIPE = "itemInRecipe";
    private static final String NBT_IS_VALID_RITUAL = "isValidRitual";
    private static final String NBT_COUNTER = "counter";
    private ItemStack heldItem = ItemStack.EMPTY;
    private boolean itemInRecipe = false;
    private boolean isValidRitual = false;
    private int counter = 0;

    public RitualCorePedestalEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.RITUAL_CORE.get(), pPos, pBlockState);
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack newItem) {
        this.heldItem = newItem;
        this.counter = 0;
        this.isValidRitual = false;
        this.itemInRecipe = false;
        if (!newItem.isEmpty() && RitualHelper.isItemInRecipeRecipe(this.level, newItem)) {
            this.itemInRecipe = true;
        }
        this.setChanged();
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{this.heldItem});
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)simpleContainer);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.readNBT(pTag, pRegistries);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registryAccess) {
        this.writeNBT(tag, registryAccess);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    private CompoundTag writeNBT(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (!this.heldItem.isEmpty()) {
            nbt.put(NBT_HELD_ITEM, this.heldItem.save(pRegistries));
        } else {
            nbt.put(NBT_HELD_ITEM, (Tag)new CompoundTag());
        }
        nbt.putBoolean(NBT_ITEM_IN_RECIPE, this.itemInRecipe);
        nbt.putBoolean(NBT_IS_VALID_RITUAL, this.isValidRitual);
        nbt.putInt(NBT_COUNTER, this.counter);
        return nbt;
    }

    private CompoundTag readNBT(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (nbt.contains(NBT_HELD_ITEM)) {
            this.heldItem = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound(NBT_HELD_ITEM));
        }
        this.itemInRecipe = nbt.getBoolean(NBT_ITEM_IN_RECIPE);
        this.isValidRitual = nbt.getBoolean(NBT_IS_VALID_RITUAL);
        this.counter = nbt.getInt(NBT_COUNTER);
        return nbt;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (this.itemInRecipe && !this.heldItem.isEmpty()) {
            boolean wasValidRitual = this.isValidRitual;
            this.isValidRitual = RitualHelper.isValidRecipe(pLevel, pPos, this.getHeldItem());
            if (!wasValidRitual && this.isValidRitual) {
                AlshanexFamiliarsMod.LOGGER.debug("Ritual started for item: " + String.valueOf(this.heldItem.getItem()));
            }
        } else {
            this.isValidRitual = false;
            this.counter = 0;
        }
        if (this.isValidRitual) {
            if (this.counter < 100) {
                ParticleOptions particles;
                Item result;
                ++this.counter;
                if (this.counter % 10 == 0 && (result = RitualHelper.getResultForRecipe(pLevel, pPos, this.getHeldItem())) != null && (particles = RitualHelper.getParticleForRecipe(pLevel, pPos, this.getHeldItem())) != null) {
                    RitualHelper.spawnParticlesAtPedestals(particles, pPos, pLevel);
                }
            }
            if (this.counter >= 100) {
                this.completeRitual(pLevel, pPos, pState);
            }
        }
    }

    private void completeRitual(Level pLevel, BlockPos pPos, BlockState pState) {
        Item result = RitualHelper.getResultForRecipe(pLevel, pPos, this.getHeldItem());
        if (result != null) {
            MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 6.0f), (double)pPos.getX(), (double)((float)pPos.getY() + 0.165f), (double)pPos.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            RitualHelper.clearItemsFromPedestals(pLevel, pPos);
            BlockState prevState = this.getBlockState();
            this.setHeldItem(new ItemStack((ItemLike)result));
            BlockState nextState = this.getBlockState();
            pLevel.sendBlockUpdated(pPos, prevState, nextState, 2);
            AlshanexFamiliarsMod.LOGGER.debug("Ritual completed! Result: " + String.valueOf(result));
        }
        this.counter = 0;
        this.itemInRecipe = false;
        this.isValidRitual = false;
    }
}

