/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.DitherMode;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmStyle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FilmProperties(ExposureType type, Optional<Integer> size, ResourceKey<ColorPalette> colorPalette, DitherMode ditherMode, FilmStyle style) {
    public static final Codec<FilmProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExposureType.CODEC.optionalFieldOf("type", (Object)ExposureType.COLOR).forGetter(FilmProperties::type), (App)ExtraCodecs.intRange((int)0, (int)2048).optionalFieldOf("frame_size").forGetter(FilmProperties::size), (App)ResourceKey.codec(Exposure.Registries.COLOR_PALETTE).optionalFieldOf("color_palette", ColorPalettes.DEFAULT).forGetter(FilmProperties::colorPalette), (App)DitherMode.CODEC.optionalFieldOf("dither_mode", (Object)DitherMode.DITHERED).forGetter(FilmProperties::ditherMode), (App)FilmStyle.CODEC.optionalFieldOf("style", (Object)FilmStyle.EMPTY).forGetter(FilmProperties::style)).apply((Applicative)instance, FilmProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FilmProperties> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FilmProperties>(){

        public void encode(RegistryFriendlyByteBuf buffer, FilmProperties data) {
            ExposureType.STREAM_CODEC.encode((Object)buffer, (Object)data.type());
            ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT).encode((Object)buffer, data.size());
            ResourceKey.streamCodec(Exposure.Registries.COLOR_PALETTE).encode((Object)buffer, data.colorPalette());
            DitherMode.STREAM_CODEC.encode((Object)buffer, (Object)data.ditherMode());
            FilmStyle.STREAM_CODEC.encode((Object)buffer, (Object)data.style());
        }

        @NotNull
        public FilmProperties decode(RegistryFriendlyByteBuf buffer) {
            return new FilmProperties((ExposureType)((Object)ExposureType.STREAM_CODEC.decode((Object)buffer)), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT).decode((Object)buffer), (ResourceKey<ColorPalette>)((ResourceKey)ResourceKey.streamCodec(Exposure.Registries.COLOR_PALETTE).decode((Object)buffer)), (DitherMode)((Object)DitherMode.STREAM_CODEC.decode((Object)buffer)), (FilmStyle)FilmStyle.STREAM_CODEC.decode((Object)buffer));
        }
    };
    public static final FilmProperties EMPTY = new FilmProperties(ExposureType.COLOR, Optional.empty(), ColorPalettes.DEFAULT, DitherMode.DITHERED, FilmStyle.EMPTY);

    public FilmProperties {
        size.ifPresent(s -> Preconditions.checkArgument((s > 0 && s <= 2048 ? 1 : 0) != 0, (Object)("size must be 1-2048: " + String.valueOf(size))));
    }

    public FilmProperties withType(ExposureType type) {
        return new FilmProperties(type, this.size, this.colorPalette, this.ditherMode, this.style);
    }

    public FilmProperties withSize(@Nullable Integer size) {
        return new FilmProperties(this.type, Optional.ofNullable(size), this.colorPalette, this.ditherMode, this.style);
    }

    public FilmProperties withColorPalette(@NotNull ResourceKey<ColorPalette> colorPalette) {
        return new FilmProperties(this.type, this.size, colorPalette, this.ditherMode, this.style);
    }

    public FilmProperties withDitherMode(DitherMode ditherMode) {
        return new FilmProperties(this.type, this.size, this.colorPalette, ditherMode, this.style);
    }

    public FilmProperties withStyle(@NotNull FilmStyle style) {
        return new FilmProperties(this.type, this.size, this.colorPalette, this.ditherMode, style);
    }

    public int getSize() {
        return this.size.orElse((Integer)Config.Server.DEFAULT_FRAME_SIZE.get());
    }

    public Holder<ColorPalette> getColorPalette(RegistryAccess access) {
        return ColorPalettes.get(access, this.colorPalette);
    }
}

