/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.cycles.task;

import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import java.util.concurrent.CompletableFuture;

public class OverrideTask<T>
extends Task<T> {
    private final Task<T> base;
    private final Task<T> override;

    public OverrideTask(Task<T> base, Task<T> override) {
        this.base = base;
        this.override = override;
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.base.execute().thenCompose(baseResult -> ((CompletableFuture)this.override.execute().exceptionally(exception -> baseResult)).thenApply(overrideResult -> {
            Result result;
            if (overrideResult instanceof Result && (result = (Result)overrideResult).isError()) {
                return this.isResultSuccessful(baseResult) ? baseResult : overrideResult;
            }
            return overrideResult;
        }));
    }

    private boolean isResultSuccessful(T resultValue) {
        Result result;
        return resultValue != null && (!(resultValue instanceof Result) || (result = (Result)resultValue).isSuccessful());
    }

    @Override
    public void tick() {
        this.base.tick();
        this.override.tick();
    }

    @Override
    public boolean isDone() {
        return this.base.isDone() && this.override.isDone();
    }

    @Override
    public boolean isStarted() {
        return this.base.isStarted() || this.override.isStarted();
    }
}

