/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.clientbound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record ActiveCameraOnStandSetS2CP(int operatorEntityId, int cameraStandId, CameraId cameraId) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("active_camera_on_stand_set");
    public static final CustomPacketPayload.Type<ActiveCameraOnStandSetS2CP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ActiveCameraOnStandSetS2CP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ActiveCameraOnStandSetS2CP::operatorEntityId, CameraId.STREAM_CODEC, ActiveCameraOnStandSetS2CP::cameraId, (StreamCodec)ByteBufCodecs.VAR_INT, ActiveCameraOnStandSetS2CP::cameraStandId, (operatorEntityId1, cameraId1, cameraStandId1) -> new ActiveCameraOnStandSetS2CP((int)operatorEntityId1, (int)cameraStandId1, (CameraId)cameraId1));

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow flow, Player player) {
        Entity entity = player.level().getEntity(this.operatorEntityId);
        if (entity instanceof CameraOperator) {
            CameraOperator operator = (CameraOperator)entity;
            entity = player.level().getEntity(this.cameraStandId);
            if (entity instanceof CameraStandEntity) {
                CameraStandEntity cameraStand = (CameraStandEntity)entity;
                operator.setActiveExposureCamera(new CameraOnStand(operator, cameraStand, this.cameraId));
            }
        }
        return true;
    }
}

