/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandSetRotationsS2CP;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public class ServerEntityMixin {
    @Shadow
    @Final
    private Entity entity;

    @Inject(method={"addPairing(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="RETURN")})
    private void onAddPairing(ServerPlayer player, CallbackInfo ci) {
        Entity entity = this.entity;
        if (entity instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)entity;
            Packets.sendToClient(new CameraStandSetRotationsS2CP(stand.getId(), stand.getYRot(), stand.getXRot()), player);
        }
    }

    @Inject(method={"sendChanges()V"}, at={@At(value="RETURN")})
    private void onSendChanges(CallbackInfo ci) {
        Entity entity = this.entity;
        if (entity instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)entity;
            stand.syncRotationToClientsIfNeeded();
        }
    }
}

