/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import io.github.mortuusars.exposure.world.camera.FilmColor;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class TintedNegativeFilmEffect
implements PixelEffect {
    private final FilmColor tintColor;

    public TintedNegativeFilmEffect(FilmColor tintColor) {
        this.tintColor = tintColor;
    }

    @Override
    public String getIdentifier() {
        return "tinted-negative-film-" + String.valueOf(this.tintColor);
    }

    @Override
    public int modify(int ARGB) {
        int alpha = FastColor.ARGB32.alpha((int)ARGB);
        int red = FastColor.ARGB32.red((int)ARGB);
        int green = FastColor.ARGB32.green((int)ARGB);
        int blue = FastColor.ARGB32.blue((int)ARGB);
        int brightness = (red + green + blue) / 3;
        int opacity = (int)Mth.clamp((float)((float)brightness * 1.5f), (float)0.0f, (float)255.0f);
        alpha = alpha * opacity / 255;
        red = 255 - red;
        green = 255 - green;
        blue = 255 - blue;
        red = (int)((float)red * this.tintColor.r() / 255.0f);
        green = (int)((float)green * this.tintColor.g() / 255.0f);
        blue = (int)((float)blue * this.tintColor.b() / 255.0f);
        return FastColor.ARGB32.color((int)alpha, (int)red, (int)green, (int)blue);
    }
}

