/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import io.github.mortuusars.exposure.util.color.Color;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class AgedHSBEffect
implements PixelEffect {
    protected final int tintColor;
    protected final float tintOpacity;
    protected final int blackPoint;
    protected final int whitePoint;

    public AgedHSBEffect(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdentifier() {
        return "aged";
    }

    @Override
    public int modify(int ARGB) {
        int alpha = FastColor.ARGB32.alpha((int)ARGB);
        int red = FastColor.ARGB32.red((int)ARGB);
        int green = FastColor.ARGB32.green((int)ARGB);
        int blue = FastColor.ARGB32.blue((int)ARGB);
        red = (int)Mth.map((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)Mth.map((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        blue = (int)Mth.map((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        float[] baseHSB = new float[3];
        Color.HSB.RGBtoHSB(red, green, blue, baseHSB);
        float[] tintHSB = new float[3];
        Color.HSB.RGBtoHSB(FastColor.ARGB32.red((int)this.tintColor), FastColor.ARGB32.green((int)this.tintColor), FastColor.ARGB32.blue((int)this.tintColor), tintHSB);
        int luma = Mth.clamp((int)((int)(0.45 * (double)red + 0.65 * (double)green + 0.2 * (double)blue)), (int)0, (int)255);
        int tintedRGB = Color.HSB.HSBtoRGB(tintHSB[0], tintHSB[1], (float)luma / 255.0f);
        int newBlue = Mth.clamp((int)((int)Mth.lerp((float)this.tintOpacity, (float)blue, (float)FastColor.ARGB32.blue((int)tintedRGB))), (int)0, (int)255);
        int newGreen = Mth.clamp((int)((int)Mth.lerp((float)this.tintOpacity, (float)green, (float)FastColor.ARGB32.green((int)tintedRGB))), (int)0, (int)255);
        int newRed = Mth.clamp((int)((int)Mth.lerp((float)this.tintOpacity, (float)red, (float)FastColor.ARGB32.red((int)tintedRGB))), (int)0, (int)255);
        return FastColor.ARGB32.color((int)alpha, (int)newRed, (int)newGreen, (int)newBlue);
    }

    public String toString() {
        return "AgedHSBPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

