/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import dev.corgitaco.ohthetreesyoullgrow.world.level.chunk.RandomTickScheduler;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class TreeFromStructureNBTFeature
extends Feature<TreeFromStructureNBTConfig> {
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean place(FeaturePlaceContext<TreeFromStructureNBTConfig> featurePlaceContext) {
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.config();
        BlockStateProvider logProvider = config.logProvider();
        BlockStateProvider leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.level();
        StructureTemplateManager templateManager = level.getLevel().getStructureManager();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.get(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.get(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List basePalettes = baseTemplate.palettes;
        List canopyPalettes = canopyTemplate.palettes;
        BlockPos origin = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().setRotation(Rotation.getRandom((RandomSource)random));
        StructureTemplate.Palette trunkBasePalette = placeSettings.getRandomPalette(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.getRandomPalette(canopyPalettes, origin);
        List center = trunkBasePalette.blocks(Blocks.WHITE_WOOL);
        if (center.isEmpty()) {
            throw new IllegalArgumentException("No trunk central position was specified for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one trunk central position for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.getFirst()).pos();
        centerOffset = new BlockPos(-centerOffset.getX(), 0, -centerOffset.getZ());
        List<StructureTemplate.StructureBlockInfo> logs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), trunkBasePalette);
        List logBuilders = trunkBasePalette.blocks(Blocks.RED_WOOL);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        int trunkLength = config.height().sample(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos, config.growableOn())) continue;
            return false;
        }
        HashMap<BlockPos, BlockState> leavePositions = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, BlockState> logPositions = new HashMap<BlockPos, BlockState>();
        TreeFromStructureNBTFeature.fillTrunkPositions(logProvider, leavesProvider, config, level, random, origin, placeSettings, trunkBasePalette, centerOffset, logs, logBuilders, leavePositions, logPositions, maxTrunkBuildingDepth);
        if (!TreeFromStructureNBTFeature.fillCanopyPositions(trunkBasePalette.blocks(Blocks.YELLOW_WOOL), config, level, random, placeSettings, centerOffset, origin, randomCanopyPalette, leavePositions, logPositions, trunkLength)) {
            return false;
        }
        if (config.isSapling() && TreeFromStructureNBTFeature.validateLogPositions(logPositions, config, level)) {
            return false;
        }
        if (TreeFromStructureNBTFeature.insideStructure(logPositions, level, config)) {
            return false;
        }
        TreeFromStructureNBTFeature.placeKnownLogPositions(logPositions, level);
        TreeFromStructureNBTFeature.placeKnownLeavePositions(leavePositions, level);
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, trunkBasePalette, centerOffset);
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, randomCanopyPalette, centerOffset);
        HashSet<BlockPos> decorationPositions = new HashSet<BlockPos>();
        TreeFromStructureNBTFeature.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions.keySet(), logPositions.keySet(), decorationPositions);
        return true;
    }

    private static boolean fillCanopyPositions(List<StructureTemplate.StructureBlockInfo> canopyAnchor, TreeFromStructureNBTConfig config, WorldGenLevel level, RandomSource randomSource, StructurePlaceSettings placeSettings, BlockPos centerOffset, BlockPos origin, StructureTemplate.Palette randomCanopyPalette, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> logPositions, int trunkLength) {
        if (!canopyAnchor.isEmpty()) {
            if (canopyAnchor.size() > 1) {
                throw new IllegalArgumentException("There cannot be more than one central canopy position. Canopy central position is specified with yellow wool on the trunk palette.");
            }
            return TreeFromStructureNBTFeature.fillCanopyPositions(config.logProvider(), config.leavesProvider(), config, level, randomSource, TreeFromStructureNBTFeature.getModifiedPos(placeSettings, canopyAnchor.getFirst(), centerOffset, origin), placeSettings, randomCanopyPalette, leavePositions, logPositions, trunkLength);
        }
        return TreeFromStructureNBTFeature.fillCanopyPositions(config.logProvider(), config.leavesProvider(), config, level, randomSource, origin, placeSettings, randomCanopyPalette, leavePositions, logPositions, trunkLength);
    }

    private static boolean insideStructure(Map<BlockPos, BlockState> logPositions, WorldGenLevel level, TreeFromStructureNBTConfig config) {
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            for (BlockPos trunkPosition : logPositions.keySet()) {
                ChunkAccess chunk = level.getChunk(trunkPosition);
                for (StructureStart structureStart : chunk.getAllStarts().values()) {
                    for (StructurePiece piece : structureStart.getPieces()) {
                        if (!piece.getBoundingBox().isInside((Vec3i)trunkPosition) || TreeFromStructureNBTFeature.testValidPos(config, level, trunkPosition)) continue;
                        return true;
                    }
                }
                for (Map.Entry entry : chunk.getAllReferences().entrySet()) {
                    Structure structure = (Structure)entry.getKey();
                    LongSet references = (LongSet)entry.getValue();
                    LongIterator longIterator = references.iterator();
                    while (longIterator.hasNext()) {
                        ChunkAccess referenceChunk;
                        StructureStart startForStructure;
                        int chunkZ;
                        long reference = (Long)longIterator.next();
                        int chunkX = ChunkPos.getX((long)reference);
                        if (!region.hasChunk(chunkX, chunkZ = ChunkPos.getZ((long)reference)) || (startForStructure = (referenceChunk = region.getChunk(chunkX, chunkZ, ChunkStatus.STRUCTURE_STARTS, true)).getStartForStructure(structure)) == null) continue;
                        for (StructurePiece piece : startForStructure.getPieces()) {
                            if (!piece.getBoundingBox().isInside((Vec3i)trunkPosition) || TreeFromStructureNBTFeature.testValidPos(config, level, trunkPosition)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean validateLogPositions(Map<BlockPos, BlockState> logPositions, TreeFromStructureNBTConfig config, WorldGenLevel level) {
        for (BlockPos trunkPosition : logPositions.keySet()) {
            if (TreeFromStructureNBTFeature.testValidPos(config, level, trunkPosition)) continue;
            return true;
        }
        return false;
    }

    private static boolean testValidPos(TreeFromStructureNBTConfig config, WorldGenLevel level, BlockPos trunkPosition) {
        return config.leavesPlacementFilter().test((Object)level, (Object)trunkPosition);
    }

    private static void placeKnownLogPositions(Map<BlockPos, BlockState> trunkPositions, WorldGenLevel level) {
        for (Map.Entry<BlockPos, BlockState> entry : trunkPositions.entrySet()) {
            BlockPos trunkPosition = entry.getKey();
            BlockState state = entry.getValue();
            level.setBlock(trunkPosition, state, 2);
        }
    }

    private static void placeKnownLeavePositions(Map<BlockPos, BlockState> leavePositions, WorldGenLevel level) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leavePositions.size());
        for (Map.Entry<BlockPos, BlockState> entry : leavePositions.entrySet()) {
            BlockPos leavePosition = entry.getKey();
            BlockState state = entry.getValue();
            level.setBlock(leavePosition, state, 2);
            if (!state.hasProperty((Property)LeavesBlock.DISTANCE)) continue;
            Runnable postProcess = () -> {
                BlockState blockState = LeavesBlock.updateDistance((BlockState)state, (LevelAccessor)level, (BlockPos)leavePosition);
                if ((Integer)blockState.getValue((Property)LeavesBlock.DISTANCE) < 7) {
                    if (blockState.hasProperty((Property)LeavesBlock.PERSISTENT)) {
                        blockState = (BlockState)blockState.setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false));
                    }
                    level.setBlock(leavePosition, blockState, 2);
                    level.scheduleTick(leavePosition, blockState.getBlock(), 0);
                } else {
                    level.removeBlock(leavePosition, false);
                    leavePositions.remove(leavePosition.immutable());
                }
            };
            leavesPostApply.add(postProcess);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void placeAdditional(TreeFromStructureNBTConfig config, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette palette, BlockPos centerOffset) {
        List<StructureTemplate.StructureBlockInfo> additionalBlocks = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.placeFromNBT(), palette);
        for (StructureTemplate.StructureBlockInfo additionalBlock : additionalBlocks) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, additionalBlock, centerOffset, origin);
            level.setBlock(pos, additionalBlock.state(), 2);
            ((RandomTickScheduler)level.getChunk(pos)).scheduleRandomTick(pos.immutable());
        }
    }

    public static void fillTrunkPositions(BlockStateProvider logProvider, BlockStateProvider leavesProvider, TreeFromStructureNBTConfig config, WorldGenLevel level, RandomSource randomSource, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette trunkBasePalette, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, List<StructureTemplate.StructureBlockInfo> logBuilders, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> trunkPositions, int maxTrunkBuildingDepth) {
        TreeFromStructureNBTFeature.fillLogsUnder(logProvider, level, randomSource, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth, config.growableOn(), trunkPositions);
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, randomSource, origin, placeSettings, centerOffset, logs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, randomSource, placeSettings, TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), trunkBasePalette), leavePositions, centerOffset, config.leavesPlacementFilter());
    }

    public static boolean fillCanopyPositions(BlockStateProvider logProvider, BlockStateProvider leavesProvider, TreeFromStructureNBTConfig config, WorldGenLevel level, RandomSource randomSource, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette randomCanopyPalette, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> trunkPositions, int trunkLength) {
        ArrayList<StructureTemplate.StructureBlockInfo> trunkFillers;
        List<StructureTemplate.StructureBlockInfo> leaves = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), randomCanopyPalette);
        List<StructureTemplate.StructureBlockInfo> canopyLogs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), randomCanopyPalette);
        List canopyAnchor = randomCanopyPalette.blocks(Blocks.WHITE_WOOL);
        if (canopyAnchor.isEmpty()) {
            throw new IllegalArgumentException("No canopy anchor was specified for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        if (canopyAnchor.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one canopy anchor for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.getFirst();
        BlockPos canopyCenterOffset = structureBlockInfo.pos();
        if (!TreeFromStructureNBTFeature.intersectTrunk(logProvider, level, randomSource, origin, placeSettings, canopyCenterOffset = new BlockPos(-canopyCenterOffset.getX(), trunkLength, -canopyCenterOffset.getZ()), trunkFillers = new ArrayList<StructureTemplate.StructureBlockInfo>(randomCanopyPalette.blocks(Blocks.RED_WOOL)), trunkLength + 1, trunkPositions)) {
            return false;
        }
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, randomSource, origin, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, randomSource, placeSettings, leaves, leavePositions, canopyCenterOffset, config.leavesPlacementFilter());
        return true;
    }

    public static void placeLogsWithRotation(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, Map<BlockPos, BlockState> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo trunk : logs) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            trunkPositions.put(pos.immutable(), TreeFromStructureNBTFeature.getTransformedState(pos, logProvider.getState(random, pos), trunk.state(), placeSettings.getRotation(), level));
        }
    }

    public static void placeTreeDecorations(Iterable<TreeDecorator> treeDecorators, WorldGenLevel level, RandomSource random, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions) {
        for (TreeDecorator treeDecorator : treeDecorators) {
            treeDecorator.place(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> {
                level.setBlock(pos, state, 2);
                decorationPositions.add(pos.immutable());
            }, random, trunkPositions, leavePositions, trunkPositions));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, List<StructureTemplate.StructureBlockInfo> leaves, Map<BlockPos, BlockState> leavePositions, BlockPos canopyCenterOffset, BlockPredicate leavesPlacementFilter) {
        for (StructureTemplate.StructureBlockInfo leaf : leaves) {
            BlockPos modifiedPos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            if (!leavesPlacementFilter.test((Object)level, (Object)modifiedPos)) continue;
            leavePositions.put(modifiedPos.immutable(), TreeFromStructureNBTFeature.getTransformedState(modifiedPos, leavesProvider.getState(random, modifiedPos), leaf.state(), placeSettings.getRotation(), level));
        }
    }

    public static void fillLogsUnder(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, BlockPredicate groundFilter, Map<BlockPos, BlockState> trunkPositions) {
        block0: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (groundFilter.test((Object)level, (Object)mutableBlockPos) || level.getBlockState((BlockPos)mutableBlockPos).is(Blocks.BEDROCK)) {
                    ((RandomTickScheduler)level.getChunk((BlockPos)mutableBlockPos)).scheduleRandomTick(mutableBlockPos.immutable());
                    continue block0;
                }
                trunkPositions.put(mutableBlockPos.immutable(), TreeFromStructureNBTFeature.getTransformedState((BlockPos)mutableBlockPos, logProvider.getState(random, (BlockPos)mutableBlockPos), logBuilder.state(), placeSettings.getRotation(), level));
                mutableBlockPos.move(Direction.DOWN);
            }
        }
    }

    public static boolean intersectTrunk(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, Map<BlockPos, BlockState> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
            for (int i = 0; i <= maxTrunkBuildingDepth && !trunkPositions.containsKey(mutableBlockPos); ++i) {
                trunkPositions.put(mutableBlockPos.immutable(), TreeFromStructureNBTFeature.getTransformedState((BlockPos)mutableBlockPos, logProvider.getState(random, (BlockPos)mutableBlockPos), logBuilder.state(), placeSettings.getRotation(), level));
                mutableBlockPos.move(Direction.DOWN);
                if (i != maxTrunkBuildingDepth) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static BlockState getTransformedState(BlockPos modifiedPos, BlockState state, BlockState nbtState, Rotation rotation, WorldGenLevel level) {
        for (Property property : state.getProperties()) {
            if (!nbtState.hasProperty(property)) continue;
            Comparable value = nbtState.getValue(property);
            state = (BlockState)state.setValue(property, value);
        }
        if (state.hasProperty((Property)LeavesBlock.WATERLOGGED)) {
            FluidState fluidState = level.getFluidState(modifiedPos);
            state = fluidState.is((Fluid)Fluids.WATER) && fluidState.getAmount() >= 7 ? (BlockState)state.setValue((Property)LeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)LeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        state = state.rotate(rotation);
        return state;
    }

    public static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos, BlockPredicate growableOn) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.move(Direction.DOWN);
            if (!growableOn.test((Object)level, (Object)mutableBlockPos)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)placing.pos()).offset((Vec3i)featureOrigin).offset((Vec3i)StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }

    public static List<StructureTemplate.StructureBlockInfo> getStructureInfosInStructurePalletteFromBlockList(Iterable<Block> blocks, StructureTemplate.Palette palette) {
        ArrayList<StructureTemplate.StructureBlockInfo> result = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (Block block : blocks) {
            result.addAll(palette.blocks(block));
        }
        return result;
    }
}

