/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.lyof.phantasm.world.feature.tree.ModTrunkTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PreamTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<PreamTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PreamTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PreamTrunkPlacer::new));

    public PreamTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModTrunkTypes.PREAM_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        TrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)startPos.below(), (TreeConfiguration)config);
        height = this.getTreeHeight(random) + 1;
        int f = height >= this.getTreeHeight(random) ? random.nextIntBetweenInclusive(3, height) : -1;
        ArrayList<FoliagePlacer.FoliageAttachment> foliages = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int i = 0; i < height; ++i) {
            this.placeLog(reader, consumer, random, startPos.above(i), config);
        }
        if (f >= 0) {
            foliages.add(new FoliagePlacer.FoliageAttachment(startPos.above(f), 0, false));
        }
        foliages.add(new FoliagePlacer.FoliageAttachment(startPos.above(height), 0, false));
        return foliages;
    }
}

