/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import net.lyof.phantasm.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class OblivineFeature
extends Feature<BlockColumnConfiguration> {
    public static final Feature<BlockColumnConfiguration> INSTANCE = new OblivineFeature((Codec<BlockColumnConfiguration>)BlockColumnConfiguration.CODEC);

    public OblivineFeature(Codec<BlockColumnConfiguration> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<BlockColumnConfiguration> context) {
        WorldGenLevel accessor = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockColumnConfiguration config = (BlockColumnConfiguration)context.config();
        int size = accessor.getRandom().nextIntBetweenInclusive(4, 12);
        BlockPos pos = new BlockPos((Vec3i)origin).atY(0);
        while (!(pos.getY() >= accessor.getHeight() || accessor.getBlockState(pos.above()).is((Block)ModBlocks.OBLIVION.get()) && accessor.getBlockState(pos).is(Blocks.AIR))) {
            pos = pos.above();
        }
        for (int i = 0; i < size; ++i) {
            if (pos.getY() < accessor.getMinBuildHeight() || pos.getY() > 250) {
                return true;
            }
            BlockState state = ((BlockColumnConfiguration.Layer)config.layers().get(0)).state().getState(random, pos);
            accessor.setBlock(pos, state, 3);
            pos = pos.below();
        }
        if (random.nextInt(5) == 0) {
            accessor.setBlock(pos, ((Block)ModBlocks.CRYSTALILY.get()).defaultBlockState(), 3);
        }
        if (Math.random() < 0.9) {
            FeaturePlaceContext contextnext = new FeaturePlaceContext(context.topFeature(), context.level(), context.chunkGenerator(), context.random(), context.origin().east(random.nextIntBetweenInclusive(-5, 5)).north(random.nextIntBetweenInclusive(-5, 5)), (FeatureConfiguration)config);
            this.place((FeaturePlaceContext<BlockColumnConfiguration>)contextnext);
        }
        return true;
    }
}

