/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.world.biome.EndDataCompat;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Climate.ParameterList.class}, priority=1100)
public abstract class ClimateParameterListMixin<T> {
    @Unique
    private final List<Pair<Climate.ParameterPoint, T>> endEntries = new ArrayList<Pair<Climate.ParameterPoint, T>>();

    @Shadow
    public abstract List<Pair<Climate.ParameterPoint, T>> values();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Climate$RTree;create(Ljava/util/List;)Lnet/minecraft/world/level/biome/Climate$RTree;"))
    public Climate.RTree<T> addEndBiomes(List<Pair<Climate.ParameterPoint, T>> entries) {
        Climate.ParameterPoint highlands = null;
        for (Pair<Climate.ParameterPoint, T> e : entries) {
            Holder r;
            Object object = e.getSecond();
            if (!(object instanceof Holder) || !(r = (Holder)object).is(Biomes.END_HIGHLANDS)) continue;
            highlands = (Climate.ParameterPoint)e.getFirst();
        }
        if (highlands != null && ModBiomes.LOOKUP != null) {
            int customCount = EndDataCompat.getEnabledBiomes().size();
            int j = 0;
            for (ResourceKey resourceKey : EndDataCompat.getEnabledBiomes()) {
                Phantasm.log("Adding " + String.valueOf(resourceKey.location()) + " to the End biome source at slice " + (j / 2 + 1) + " out of " + customCount);
                this.endEntries.add(new Pair((Object)ClimateParameterListMixin.splitHypercube(highlands, customCount, j), (Object)ModBiomes.LOOKUP.getOrThrow(resourceKey)));
                j += 2;
            }
            this.endEntries.addAll(entries.stream().filter(p -> {
                Holder k;
                Object patt1$temp;
                Holder r;
                Object patt0$temp = p.getSecond();
                return patt0$temp instanceof Holder && !(r = (Holder)patt0$temp).is(Biomes.END_HIGHLANDS) && (!((patt1$temp = r.unwrapKey().get()) instanceof Holder) || !EndDataCompat.contains((Holder<Biome>)(k = (Holder)patt1$temp)));
            }).toList());
            for (int i = 1; i <= customCount; i += 2) {
                this.endEntries.add(new Pair((Object)ClimateParameterListMixin.splitHypercube(highlands, customCount, i), (Object)ModBiomes.LOOKUP.getOrThrow(Biomes.END_HIGHLANDS)));
            }
            return Climate.RTree.create(this.endEntries);
        }
        return Climate.RTree.create(entries);
    }

    @Unique
    private static Climate.ParameterPoint splitHypercube(Climate.ParameterPoint base, int biomes, int i) {
        biomes = biomes * 2 - 1;
        if (EndDataCompat.getCompatibilityMode().equals("endercon")) {
            return Climate.parameters((Climate.Parameter)ClimateParameterListMixin.splitRange(base.temperature(), biomes, i), (Climate.Parameter)base.humidity(), (Climate.Parameter)base.continentalness(), (Climate.Parameter)base.erosion(), (Climate.Parameter)base.depth(), (Climate.Parameter)base.weirdness(), (float)((float)base.offset() / 10000.0f));
        }
        if (EndDataCompat.getCompatibilityMode().equals("nullscape")) {
            return Climate.parameters((Climate.Parameter)base.temperature(), (Climate.Parameter)base.humidity(), (Climate.Parameter)base.continentalness(), (Climate.Parameter)base.erosion(), (Climate.Parameter)base.depth(), (Climate.Parameter)ClimateParameterListMixin.splitRange(base.weirdness(), biomes, i), (float)((float)base.offset() / 10000.0f));
        }
        return Climate.parameters((Climate.Parameter)base.temperature(), (Climate.Parameter)base.humidity(), (Climate.Parameter)ClimateParameterListMixin.splitRange(base.continentalness(), biomes, i), (Climate.Parameter)base.erosion(), (Climate.Parameter)base.depth(), (Climate.Parameter)base.weirdness(), (float)((float)base.offset() / 10000.0f));
    }

    @Unique
    private static Climate.Parameter splitRange(Climate.Parameter point, int biomes, int i) {
        long min = ClimateParameterListMixin.getRange(point) / (long)biomes * (long)i + point.min();
        long max = ClimateParameterListMixin.getRange(point) / (long)biomes * (long)(i + 1) + point.min();
        return Climate.Parameter.span((float)((float)min / 10000.0f), (float)((float)max / 10000.0f));
    }

    @Unique
    private static long getRange(Climate.Parameter point) {
        return point.max() - point.min();
    }

    @ModifyArg(method={"<init>"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Climate$RTree;create(Ljava/util/List;)Lnet/minecraft/world/level/biome/Climate$RTree;"))
    public List<Pair<Climate.ParameterPoint, T>> modifyTree(List<Pair<Climate.ParameterPoint, T>> entries) {
        return this.values();
    }

    @Inject(method={"values"}, at={@At(value="HEAD")}, cancellable=true)
    public void redirectEntries(CallbackInfoReturnable<List<Pair<Climate.ParameterPoint, T>>> cir) {
        if (!this.endEntries.isEmpty()) {
            cir.setReturnValue(this.endEntries);
        }
    }
}

