/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.item.custom;

import java.util.List;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.item.ModItems;
import net.lyof.phantasm.item.components.ShatteredPendantData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class ShatteredPendantItem
extends Item {
    public ShatteredPendantItem(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE).stacksTo(1).durability(ConfigEntries.shatteredPendantDurability).fireResistant());
    }

    public int getBarColor(ItemStack stack) {
        return 3447176;
    }

    public static boolean canSeeSky(BlockPos pos, Level level) {
        int top = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ());
        return top <= pos.getY();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        if (entity.tickCount % 20 == 0 && entity.onGround() && ShatteredPendantItem.canSeeSky(entity.getOnPos(), level)) {
            this.updateLocation(stack, entity.getBlockX(), entity.getBlockY(), entity.getBlockZ(), level.dimension().toString());
        } else if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            if (entity.tickCount % 20 == 0 && entity.getY() <= 0.0 && level.dimension().location().toString().equals("minecraft:the_end") && (!(entity instanceof Player) || !(player = (Player)entity).getCooldowns().isOnCooldown((Item)this))) {
                living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                this.finishUsingItem(stack, level, living);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return super.use(level, player, hand);
    }

    private void updateLocation(ItemStack stack, int x, int y, int z, String id) {
        stack.set((DataComponentType)ModItems.SHATTERED_PENDANT_DATA.get(), (Object)new ShatteredPendantData(x, y, z, id));
    }

    private ShatteredPendantData getData(ItemStack stack) {
        return (ShatteredPendantData)stack.get((DataComponentType)ModItems.SHATTERED_PENDANT_DATA.get());
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (this.getData(stack).x() == 0 && this.getData(stack).y() == 0 && this.getData(stack).z() == 0) {
            Phantasm.log("naah");
            return super.finishUsingItem(stack, level, user);
        }
        if (level.dimension().toString().equals(this.getData(stack).dimensionId())) {
            user.fallDistance = 0.0f;
            user.teleportTo((double)this.getData(stack).x(), (double)this.getData(stack).y(), (double)this.getData(stack).z());
            if (user instanceof Player) {
                Player player = (Player)user;
                player.getCooldowns().addCooldown((Item)this, 200);
                stack.hurtAndBreak(1, (LivingEntity)player, user.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            user.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 2.0f);
        }
        return super.finishUsingItem(stack, level, user);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        String[] txt;
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        for (String t : txt = Component.translatable((String)"item.phantasm.shattered_pendant.desc").getString().split("\\n")) {
            tooltipComponents.add((Component)Component.literal((String)t).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(level, user, stack, remainingUseTicks);
        float sin = (float)Math.sin((double)remainingUseTicks * Math.PI / 10.0);
        float cos = (float)Math.cos((double)remainingUseTicks * Math.PI / 10.0);
        level.addParticle((ParticleOptions)ParticleTypes.END_ROD, user.getX() + (double)sin, user.getEyeY() - 0.5, user.getZ() + (double)cos, 0.0, 0.0, 0.0);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }
}

