/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities.goals;

import java.util.EnumSet;
import net.lyof.phantasm.entities.custom.CrystieEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CrystieAirMovementGoal
extends Goal {
    private final CrystieEntity crystieEntity;

    public CrystieAirMovementGoal(CrystieEntity crystie) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.crystieEntity = crystie;
    }

    public boolean canUse() {
        return this.crystieEntity.getTarget() != null && !this.crystieEntity.getMoveControl().hasWanted();
    }

    public boolean canContinueToUse() {
        return this.crystieEntity.getMoveControl().hasWanted() && this.crystieEntity.getTarget() != null && this.crystieEntity.getTarget().isAlive();
    }

    public void start() {
        LivingEntity livingentity = this.crystieEntity.getTarget();
        Vec3 vec3d = livingentity.getEyePosition(1.0f);
        this.crystieEntity.getMoveControl().setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 3.0);
    }

    public void tick() {
        LivingEntity livingentity = this.crystieEntity.getTarget();
        if (this.crystieEntity.getBoundingBox().intersects(livingentity.getBoundingBox())) {
            this.crystieEntity.doHurtTarget((Entity)livingentity);
        } else {
            double d0 = this.crystieEntity.distanceToSqr((Entity)livingentity);
            if (d0 < 32.0) {
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                this.crystieEntity.getMoveControl().setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 3.0);
            }
        }
    }
}

