/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities;

import net.lyof.phantasm.entities.custom.BehemothEntity;
import net.lyof.phantasm.entities.custom.ChoralArrowEntity;
import net.lyof.phantasm.entities.custom.CrystieEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"phantasm");
    public static final DeferredHolder<EntityType<?>, EntityType<CrystieEntity>> CRYSTIE = ModEntities.register("crystie", EntityType.Builder.of(CrystieEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<BehemothEntity>> BEHEMOTH = ModEntities.register("behemoth", EntityType.Builder.of(BehemothEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<ChoralArrowEntity>> CHORAL_ARROW = ModEntities.register("choral_arrow", EntityType.Builder.of(ChoralArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryName, EntityType.Builder<T> entityTypeBuilder) {
        return ENTITIES.register(registryName, () -> entityTypeBuilder.build(registryName));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CRYSTIE.get(), CrystieEntity.createAttributes().build());
        event.put((EntityType)BEHEMOTH.get(), BehemothEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerEntitiesSpawn(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CRYSTIE.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.WORLD_SURFACE, CrystieEntity::checkCrystieSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)BEHEMOTH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }
}

