/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.client.particles.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZzzParticle
extends TextureSheetParticle {
    public ZzzParticle(ClientLevel clientWorld, double x, double y, double z) {
        super(clientWorld, x, y, z);
    }

    public ZzzParticle(ClientLevel clientWorld, double x, double y, double z, SpriteSet sprite, float vx, float vy, float vz) {
        super(clientWorld, x, y, z);
        this.setSpriteFromAge(sprite);
        this.setPos(x, y, z);
        this.setParticleSpeed(vx, vy, vz);
        this.gravity = 0.0f;
        this.lifetime = 100;
    }

    public void tick() {
        float ratio = (float)(this.lifetime - this.age) / (float)this.lifetime;
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @NotNull
    public static Provider provider(SpriteSet spriteSet) {
        return new Provider(spriteSet);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteProvider) {
            this.sprites = spriteProvider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ZzzParticle(level, x, y, z, this.sprites, (float)velocityX, (float)velocityY, (float)velocityZ);
        }
    }
}

