/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.lyof.phantasm.entities.custom.CrystieEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class CrystieModel<T extends CrystieEntity>
extends HierarchicalModel<CrystieEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"phantasm", (String)"crystie_model"), "main");
    private final ModelPart main;
    private final ModelPart wingsleft;
    private final ModelPart wingsright;
    private final ModelPart root;

    public CrystieModel(ModelPart root) {
        this.main = root.getChild("main");
        this.wingsleft = this.main.getChild("wings").getChild("left");
        this.wingsright = this.main.getChild("wings").getChild("right");
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition main = modelPartData.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition wings = main.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition left = wings.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(2.0f, -1.0f, 2.0f, 6.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(12, 19).mirror().addBox(2.0f, 4.0f, 2.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right = wings.addOrReplaceChild("right", CubeListBuilder.create().texOffs(0, 19).addBox(-8.0f, -1.0f, 2.0f, 6.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(12, 19).addBox(-5.0f, 4.0f, 2.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        this.main.render(stack, consumer, light, overlay, color);
    }

    public void setupAnim(CrystieEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.wingsleft.yRot = (float)Math.cos(0.01 * (double)ageInTicks * 180.0 / Math.PI) / 3.0f;
        this.wingsright.yRot = (float)(-Math.cos(0.01 * (double)ageInTicks * 180.0 / Math.PI)) / 3.0f;
    }
}

