/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lyof.phantasm.config.ConfigEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SubwooferBlock
extends Block {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");

    public SubwooferBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static boolean canPush(Entity e) {
        return e.isPushable() || e instanceof ItemEntity || e instanceof Projectile;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)(ctx.getPlayer() != null && ctx.getPlayer().isShiftKeyDown() ? ctx.getNearestLookingDirection().getOpposite() : ctx.getNearestLookingDirection()));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        boolean b = level.hasNeighborSignal(pos);
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (b != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(b)), 3);
            if (b) {
                ArrayList<UUID> affected = new ArrayList<UUID>();
                for (int i = 1; i < ConfigEntries.subwooferRange; ++i) {
                    BlockPos p = pos.mutable().relative(dir, i);
                    if (level.getBlockState(p).is(BlockTags.OCCLUDES_VIBRATION_SIGNALS)) {
                        return;
                    }
                    level.blockEvent(pos, (Block)this, dir.get3DDataValue(), i);
                    level.gameEvent(null, (Holder)GameEvent.NOTE_BLOCK_PLAY, pos);
                    List entities = level.getEntities((Entity)null, new AABB(p).inflate(1.2), SubwooferBlock::canPush);
                    for (Entity e : entities) {
                        if (affected.contains(e.getUUID())) continue;
                        affected.add(e.getUUID());
                        e.setDeltaMovement(new Vec3((double)dir.getStepX(), (double)dir.getStepY() + 0.1, (double)dir.getStepZ()));
                        e.hurtMarked = true;
                        if (dir != Direction.UP) continue;
                        e.fallDistance = 0.0f;
                    }
                }
            }
        }
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int type, int data) {
        if (data == 1 && !level.getBlockState(pos.offset(((Direction)state.getValue((Property)FACING)).getOpposite().getNormal())).is(BlockTags.OCCLUDES_VIBRATION_SIGNALS)) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.BLOCKS, 0.2f, 1.5f, true);
        }
        BlockPos p = pos.mutable().relative(Direction.from3DDataValue((int)type), data);
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, 0.0, 0.0, 0.0);
        return true;
    }
}

