/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import com.mojang.serialization.MapCodec;
import net.lyof.phantasm.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PillaringPlantBlock
extends BushBlock
implements BonemealableBlock {
    public TagKey<Block> growableOn;
    public VoxelShape shape;

    public PillaringPlantBlock(BlockBehaviour.Properties properties, TagKey<Block> growableOn, VoxelShape shape) {
        super(properties);
        this.growableOn = growableOn;
        this.shape = shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return PillaringPlantBlock.simpleCodec(properties -> new PillaringPlantBlock((BlockBehaviour.Properties)properties, this.growableOn, this.shape));
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter getter, BlockPos pos) {
        return floor.is(this.growableOn);
    }

    public boolean isValidBonemealTarget(LevelReader reader, BlockPos pos, BlockState state) {
        return reader.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(3) == 0 && this.isValidBonemealTarget((LevelReader)level, pos, state);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (state.is((Block)ModBlocks.DRALGAE.get()) && random.nextInt(10) == 0) {
            level.setBlockAndUpdate(pos.above(), ((Block)ModBlocks.POME.get()).defaultBlockState());
        } else {
            level.setBlockAndUpdate(pos.above(), this.defaultBlockState());
        }
    }
}

