/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.lyof.phantasm.block.custom.CrystalShardBlock;
import net.lyof.phantasm.block.custom.DirectionalBlock;
import net.lyof.phantasm.block.custom.DragonMintBlock;
import net.lyof.phantasm.block.custom.HangingFruitBlock;
import net.lyof.phantasm.block.custom.HangingPlantBlock;
import net.lyof.phantasm.block.custom.ModRotatedPillarBlock;
import net.lyof.phantasm.block.custom.NihiliumBlock;
import net.lyof.phantasm.block.custom.PillaringPlantBlock;
import net.lyof.phantasm.block.custom.PomeBlock;
import net.lyof.phantasm.block.custom.SubwooferBlock;
import net.lyof.phantasm.block.custom.VividNihilisBlock;
import net.lyof.phantasm.block.custom.signs.ModHangingSignBlock;
import net.lyof.phantasm.block.custom.signs.ModStandingSignBlock;
import net.lyof.phantasm.block.custom.signs.ModWallHangingSignBlock;
import net.lyof.phantasm.block.custom.signs.ModWallSignBlock;
import net.lyof.phantasm.effect.ModEffects;
import net.lyof.phantasm.item.ModItems;
import net.lyof.phantasm.setup.ModTags;
import net.lyof.phantasm.world.feature.tree.TreeGenerators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"phantasm");
    private static final BlockBehaviour.Properties CrystalMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE).lightLevel(blockState -> 4).emissiveRendering((a, b, c) -> true).noOcclusion();
    private static final BlockBehaviour.Properties CrystalGlassMaterial = BlockBehaviour.Properties.of().emissiveRendering((a, b, c) -> true).strength(0.75f).lightLevel(blockState -> 4).noOcclusion().mapColor(MapColor.COLOR_LIGHT_BLUE).sound(SoundType.GLASS);
    private static final BlockBehaviour.Properties PolishedObsidianMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN).strength(7.0f);
    private static final BlockBehaviour.Properties PreamWoodMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(MapColor.COLOR_BROWN);
    private static final BlockBehaviour.Properties PreamPlankMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(MapColor.TERRACOTTA_YELLOW);
    private static final BlockBehaviour.Properties PreamPassableMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN).mapColor(MapColor.TERRACOTTA_YELLOW);
    private static final BlockBehaviour.Properties PreamLeafMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.TERRACOTTA_PURPLE);
    private static final BlockBehaviour.Properties RawPurpurMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).mapColor(MapColor.TERRACOTTA_PURPLE);
    private static final BlockBehaviour.Properties OblivionMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).mapColor(MapColor.COLOR_BLACK);
    private static final BlockBehaviour.Properties acidicMassMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).mapColor(MapColor.WARPED_HYPHAE).strength(1.8f);
    private static final BlockBehaviour.Properties pomeMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON).mapColor(MapColor.WARPED_HYPHAE).strength(1.5f);
    private static final BlockBehaviour.Properties ciriteMaterial = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.WARPED_HYPHAE).strength(2.0f, 0.2f).friction(1.0f);
    public static List<DeferredBlock> BLOCK_CUTOUT = new ArrayList<DeferredBlock>();
    public static final WoodType PREAM = new WoodType("pream", BlockSetType.OAK);
    public static final DeferredBlock<Block> FALLEN_STAR = ModBlocks.registerBlock("fallen_star", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).mapColor(MapColor.COLOR_LIGHT_BLUE).lightLevel(blockState -> 15)));
    public static final DeferredBlock<Block> POLISHED_OBSIDIAN = ModBlocks.registerBlock("polished_obsidian", () -> new Block(PolishedObsidianMaterial));
    public static final DeferredBlock<Block> POLISHED_OBSIDIAN_BRICKS = ModBlocks.registerBlock("polished_obsidian_bricks", () -> new Block(PolishedObsidianMaterial));
    public static final DeferredBlock<Block> POLISHED_OBSIDIAN_BRICKS_STAIRS = ModBlocks.registerBlock("polished_obsidian_bricks_stairs", () -> new StairBlock(((Block)POLISHED_OBSIDIAN_BRICKS.get()).defaultBlockState(), PolishedObsidianMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> POLISHED_OBSIDIAN_BRICKS_SLAB = ModBlocks.registerBlock("polished_obsidian_bricks_slab", () -> new SlabBlock(PolishedObsidianMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> CRYSTAL_SHARD = ModBlocks.registerBlock("crystal_shard", () -> new CrystalShardBlock(CrystalMaterial.lightLevel(b -> 7).sound(SoundType.GLASS)), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VOID_CRYSTAL_SHARD = ModBlocks.registerBlock("void_crystal_shard", () -> new CrystalShardBlock(CrystalMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> CRYSTAL_BLOCK = ModBlocks.registerBlock("crystal_block", () -> new Block(CrystalMaterial));
    public static final DeferredBlock<Block> CRYSTAL_TILES = ModBlocks.registerBlock("crystal_tiles", () -> new Block(CrystalMaterial));
    public static final DeferredBlock<Block> CRYSTAL_TILES_STAIRS = ModBlocks.registerBlock("crystal_tiles_stairs", () -> new StairBlock(((Block)CRYSTAL_TILES.get()).defaultBlockState(), CrystalMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> CRYSTAL_TILES_SLAB = ModBlocks.registerBlock("crystal_tiles_slab", () -> new SlabBlock(CrystalMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> CRYSTAL_PILLAR = ModBlocks.registerBlock("crystal_pillar", () -> new RotatedPillarBlock(CrystalMaterial));
    public static final DeferredBlock<Block> CRYSTAL_GLASS = ModBlocks.registerBlock("crystal_glass", () -> new Block(CrystalGlassMaterial.noOcclusion()), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> CRYSTAL_GLASS_PANE = ModBlocks.registerBlock("crystal_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.BLUE, CrystalGlassMaterial.noOcclusion()), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VOID_CRYSTAL_BLOCK = ModBlocks.registerBlock("void_crystal_block", () -> new Block(CrystalMaterial));
    public static final DeferredBlock<Block> VOID_CRYSTAL_TILES = ModBlocks.registerBlock("void_crystal_tiles", () -> new Block(CrystalMaterial));
    public static final DeferredBlock<Block> VOID_CRYSTAL_TILES_STAIRS = ModBlocks.registerBlock("void_crystal_tiles_stairs", () -> new StairBlock(((Block)VOID_CRYSTAL_TILES.get()).defaultBlockState(), CrystalGlassMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VOID_CRYSTAL_TILES_SLAB = ModBlocks.registerBlock("void_crystal_tiles_slab", () -> new SlabBlock(CrystalMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VOID_CRYSTAL_PILLAR = ModBlocks.registerBlock("void_crystal_pillar", () -> new RotatedPillarBlock(CrystalGlassMaterial));
    public static final DeferredBlock<Block> VOID_CRYSTAL_GLASS = ModBlocks.registerBlock("void_crystal_glass", () -> new Block(CrystalGlassMaterial.noOcclusion()), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VOID_CRYSTAL_GLASS_PANE = ModBlocks.registerBlock("void_crystal_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.BLUE, CrystalGlassMaterial.noOcclusion()), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> STRIPPED_PREAM_LOG = ModBlocks.log("stripped_pream_log", MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_BLUE, PreamWoodMaterial);
    public static final DeferredBlock<Block> PREAM_LOG = ModBlocks.log("pream_log", MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_BLUE, PreamWoodMaterial);
    public static final DeferredBlock<Block> STRIPPED_PREAM_WOOD = ModBlocks.log("stripped_pream_wood", MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_BLUE, PreamWoodMaterial);
    public static final DeferredBlock<Block> PREAM_WOOD = ModBlocks.log("pream_wood", MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_BLUE, PreamWoodMaterial);
    public static final DeferredBlock<Block> PREAM_LEAVES = ModBlocks.registerBlock("pream_leaves", () -> new LeavesBlock(PreamLeafMaterial), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> HANGING_PREAM_LEAVES = ModBlocks.registerBlock("hanging_pream_leaves", () -> new HangingFruitBlock(PreamLeafMaterial.noCollission(), ModTags.Blocks.HANGING_PREAM_LEAVES_GROWABLE_ON, Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), "pream_berry"), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> PREAM_PLANKS = ModBlocks.registerBlock("pream_planks", () -> new Block(PreamPlankMaterial));
    public static final DeferredBlock<Block> PREAM_STAIRS = ModBlocks.registerBlock("pream_stairs", () -> new StairBlock(((Block)PREAM_PLANKS.get()).defaultBlockState(), PreamPlankMaterial));
    public static final DeferredBlock<Block> PREAM_SLAB = ModBlocks.registerBlock("pream_slab", () -> new SlabBlock(PreamPlankMaterial));
    public static final DeferredBlock<Block> PREAM_PRESSURE_PLATE = ModBlocks.registerBlock("pream_pressure_plate", () -> new PressurePlateBlock(PREAM.setType(), PreamPassableMaterial));
    public static final DeferredBlock<Block> PREAM_BUTTON = ModBlocks.registerBlock("pream_button", () -> new ButtonBlock(PREAM.setType(), 50, PreamPassableMaterial));
    public static final DeferredBlock<Block> PREAM_FENCE = ModBlocks.registerBlock("pream_fence", () -> new FenceBlock(PreamPlankMaterial));
    public static final DeferredBlock<Block> PREAM_FENCE_GATE = ModBlocks.registerBlock("pream_fence_gate", () -> new FenceGateBlock(PREAM, PreamPlankMaterial));
    public static final DeferredBlock<Block> PREAM_DOOR = ModBlocks.registerBlock("pream_door", () -> new DoorBlock(PREAM.setType(), PreamPlankMaterial.noOcclusion()), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> PREAM_TRAPDOOR = ModBlocks.registerBlock("pream_trapdoor", () -> new TrapDoorBlock(PREAM.setType(), PreamPlankMaterial.noOcclusion()), BLOCK_CUTOUT);
    public static final DeferredHolder<Block, ModStandingSignBlock> PREAM_SIGN = BLOCKS.register("pream_sign", () -> new ModStandingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN), WoodType.OAK));
    public static final DeferredHolder<Block, ModWallSignBlock> PREAM_WALL_SIGN = BLOCKS.register("pream_wall_sign", () -> new ModWallSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN), WoodType.OAK));
    public static final DeferredHolder<Block, ModHangingSignBlock> PREAM_HANGING_SIGN = BLOCKS.register("pream_hanging_sign", () -> new ModHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN), WoodType.OAK));
    public static final DeferredHolder<Block, ModWallHangingSignBlock> PREAM_WALL_HANGING_SIGN = BLOCKS.register("pream_wall_hanging_sign", () -> new ModWallHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN), WoodType.OAK));
    public static final DeferredBlock<Block> PREAM_SAPLING = ModBlocks.registerBlock("pream_sapling", () -> new SaplingBlock(TreeGenerators.PREAM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> OBLIVINE = ModBlocks.registerBlock("oblivine", () -> new HangingFruitBlock(OblivionMaterial.instabreak().noCollission(), ModTags.Blocks.OBLIVINE_GROWABLE_ON, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), "oblifruit"), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> OBLIVION = ModBlocks.registerBlock("oblivion", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.COLOR_BLACK)));
    public static final DeferredBlock<Block> CRYSTALILY = ModBlocks.registerBlock("crystalily", () -> new HangingPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.COLOR_LIGHT_BLUE).instabreak().lightLevel(blockState -> 7).emissiveRendering((bs, br, bp) -> true), ModTags.Blocks.OBLIVINE_GROWABLE_ON, Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VIVID_NIHILIUM = ModBlocks.registerBlock("vivid_nihilium", () -> new NihiliumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE).mapColor(MapColor.COLOR_CYAN).randomTicks()), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> VIVID_NIHILIS = ModBlocks.registerBlock("vivid_nihilis", () -> new VividNihilisBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_ROOTS).mapColor(MapColor.COLOR_CYAN)){

        public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.getBlockState(pos.below()).is(BlockTags.DIRT) || reader.getBlockState(pos.below()).is(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final DeferredBlock<Block> STARFLOWER = ModBlocks.registerBlock("starflower", () -> new FlowerBlock(MobEffects.NIGHT_VISION, 100.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_ROOTS).mapColor(MapColor.COLOR_LIGHT_BLUE).instabreak().noCollission().lightLevel(state -> 5).emissiveRendering((a, b, c) -> true)){

        public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.getBlockState(pos.below()).is(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final DeferredHolder<Block, DoublePlantBlock> TALL_VIVID_NIHILIS = ModBlocks.registerOnlyBlock("tall_vivid_nihilis", () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN).mapColor(MapColor.COLOR_CYAN)){

        public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
            return state.getValue((Property)DoublePlantBlock.HALF) != DoubleBlockHalf.LOWER || reader.getBlockState(pos.below()).is(BlockTags.DIRT) || reader.getBlockState(pos.below()).is(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final DeferredBlock<NihiliumBlock> ACIDIC_NIHILIUM = ModBlocks.registerBlock("acidic_nihilium", () -> new NihiliumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE).mapColor(MapColor.WARPED_NYLIUM).randomTicks()), BLOCK_CUTOUT);
    public static final DeferredBlock<VividNihilisBlock> ACIDIC_NIHILIS = ModBlocks.registerBlock("acidic_nihilis", () -> new VividNihilisBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_ROOTS).mapColor(MapColor.WARPED_NYLIUM)){

        public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.getBlockState(pos.below()).is(BlockTags.DIRT) || reader.getBlockState(pos.below()).is(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final DeferredBlock<DoublePlantBlock> TALL_ACIDIC_NIHILIS = ModBlocks.registerOnlyBlock("tall_acidic_nihilis", () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN).mapColor(MapColor.COLOR_CYAN)){

        public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
            return state.getValue((Property)DoublePlantBlock.HALF) != DoubleBlockHalf.LOWER || reader.getBlockState(pos.below()).is(BlockTags.DIRT) || reader.getBlockState(pos.below()).is(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final DeferredBlock<DragonMintBlock> DRAGON_MINT = ModBlocks.registerBlock("dragon_mint", () -> new DragonMintBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_ROOTS).randomTicks().mapColor(MapColor.CRIMSON_STEM).sound(SoundType.CHERRY_LEAVES).offsetType(BlockBehaviour.OffsetType.NONE).lightLevel(state -> (Boolean)state.getValue((Property)HangingFruitBlock.HAS_FRUIT) != false ? 9 : 0)), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> ACIDIC_MASS = ModBlocks.registerBlock("acidic_mass", () -> new Block(acidicMassMaterial){

        public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
            if (!entity.isSteppingCarefully()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.4, 1.0, 0.4));
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.addEffect(new MobEffectInstance(ModEffects.CORROSION.getDelegate(), 100, 0));
                }
            }
            super.stepOn(level, pos, state, entity);
        }
    });
    public static final DeferredBlock<Block> DRALGAE = ModBlocks.registerBlock("dralgae", () -> new PillaringPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_ROOTS).mapColor(MapColor.CRIMSON_HYPHAE).offsetType(BlockBehaviour.OffsetType.NONE), ModTags.Blocks.DRALGAE_GROWABLE_ON, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)), BLOCK_CUTOUT);
    public static final DeferredBlock<Block> POME = ModBlocks.registerBlock("pome", () -> new PomeBlock(pomeMaterial));
    public static final DeferredBlock<Block> RAW_PURPUR = ModBlocks.registerBlock("raw_purpur", () -> new Block(RawPurpurMaterial));
    public static final DeferredBlock<Block> RAW_PURPUR_BRICKS = ModBlocks.registerBlock("raw_purpur_bricks", () -> new Block(RawPurpurMaterial));
    public static final DeferredBlock<Block> RAW_PURPUR_BRICKS_STAIRS = ModBlocks.registerBlock("raw_purpur_bricks_stairs", () -> new StairBlock(((Block)RAW_PURPUR_BRICKS.get()).defaultBlockState(), RawPurpurMaterial));
    public static final DeferredBlock<Block> RAW_PURPUR_BRICKS_SLAB = ModBlocks.registerBlock("raw_purpur_bricks_slab", () -> new SlabBlock(RawPurpurMaterial));
    public static final DeferredBlock<Block> RAW_PURPUR_TILES = ModBlocks.registerBlock("raw_purpur_tiles", () -> new Block(RawPurpurMaterial));
    public static final DeferredBlock<Block> RAW_PURPUR_PILLAR = ModBlocks.registerBlock("raw_purpur_pillar", () -> new RotatedPillarBlock(RawPurpurMaterial));
    public static final DeferredBlock<Block> PURPUR_LAMP = ModBlocks.registerBlock("purpur_lamp", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPUR_BLOCK).lightLevel(block -> 15)));
    public static final DeferredBlock<Block> CIRITE = ModBlocks.registerBlock("cirite", () -> new Block(ciriteMaterial));
    public static final DeferredBlock<Block> CIRITE_IRON_ORE = ModBlocks.registerBlock("cirite_iron_ore", () -> new Block(ciriteMaterial));
    public static final DeferredBlock<Block> CIRITE_BRICKS = ModBlocks.registerBlock("cirite_bricks", () -> new Block(ciriteMaterial));
    public static final DeferredBlock<StairBlock> CIRITE_BRICKS_STAIRS = ModBlocks.registerBlock("cirite_bricks_stairs", () -> new StairBlock(((Block)CIRITE_BRICKS.get()).defaultBlockState(), ciriteMaterial));
    public static final DeferredBlock<SlabBlock> CIRITE_BRICKS_SLAB = ModBlocks.registerBlock("cirite_bricks_slab", () -> new SlabBlock(ciriteMaterial));
    public static final DeferredBlock<Block> CHORAL_BLOCK = ModBlocks.registerBlock("choral_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRAIN_CORAL_BLOCK).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final DeferredBlock<DirectionalBlock> CHORAL_FAN = ModBlocks.registerBlock("choral_fan", () -> new DirectionalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRAIN_CORAL_FAN).mapColor(MapColor.TERRACOTTA_WHITE)), BLOCK_CUTOUT);
    public static final DeferredBlock<SubwooferBlock> SUBWOOFER_BLOCK = ModBlocks.registerBlock("subwoofer_block", () -> new SubwooferBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NOTE_BLOCK).mapColor(MapColor.TERRACOTTA_WHITE)));

    private static DeferredBlock<Block> log(String name, MapColor color, MapColor color1, BlockBehaviour.Properties properties) {
        return ModBlocks.registerBlock(name, () -> new ModRotatedPillarBlock(properties.mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? color : color1)));
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block, List<DeferredBlock> addTo) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        addTo.add(toReturn);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerOnlyBlock(String name, Supplier<T> block, List<DeferredBlock> addTo) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        addTo.add(toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredHolder<Item, BlockItem> registerBlockItem(String name, DeferredBlock<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

