/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import snownee.kiwi.customization.item.KItemSettings;
import snownee.kiwi.customization.item.loader.ConfiguredItemTemplate;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;

public record KItemDefinition(ConfiguredItemTemplate template, ItemDefinitionProperties properties) {
    public KItemDefinition(ConfiguredItemTemplate template, ItemDefinitionProperties properties) {
        this.template = template;
        this.properties = template.template().properties().map(properties::merge).orElse(properties);
    }

    public static Codec<KItemDefinition> codec(Map<ResourceLocation, KItemTemplate> templates) {
        KItemTemplate defaultTemplate = templates.get(ResourceLocation.withDefaultNamespace((String)"item"));
        Preconditions.checkNotNull((Object)defaultTemplate);
        ConfiguredItemTemplate defaultConfiguredTemplate = new ConfiguredItemTemplate(defaultTemplate);
        return RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredItemTemplate.codec(templates).optionalFieldOf("template", (Object)defaultConfiguredTemplate).forGetter(KItemDefinition::template), (App)ItemDefinitionProperties.mapCodec().forGetter(KItemDefinition::properties)).apply((Applicative)instance, KItemDefinition::new));
    }

    public KItemSettings.Builder createSettings(ResourceLocation id) {
        KItemSettings.Builder builder = KItemSettings.builder();
        ItemDefinitionProperties.PartialVanillaProperties vanilla = this.properties.vanillaProperties();
        builder.configure($ -> {
            vanilla.maxStackSize().ifPresent(arg_0 -> ((Item.Properties)$).stacksTo(arg_0));
            vanilla.maxDamage().ifPresent(arg_0 -> ((Item.Properties)$).durability(arg_0));
            vanilla.craftingRemainingItem().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).ifPresent(arg_0 -> ((Item.Properties)$).craftRemainder(arg_0));
            vanilla.components().ifPresent(componentMap -> {
                for (TypedDataComponent component : componentMap) {
                    $.component(component.type(), component.value());
                }
            });
        });
        return builder;
    }

    public Item createItem(ResourceLocation id) {
        KItemSettings.Builder builder = this.createSettings(id);
        return this.template.template().createItem(id, builder.get(), this.template.json());
    }
}

