/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.GroupSetting;
import snownee.kiwi.Kiwi;

public class KiwiGO<T>
implements Supplier<T> {
    @Nullable
    protected Supplier<T> factory;
    @Nullable
    protected ResourceKey<T> key;
    @Nullable
    protected T value;
    @Nullable
    Field field;
    @Nullable
    GroupSetting groupSetting;

    public KiwiGO(@Nullable Supplier<T> factory) {
        this.factory = factory;
    }

    @Override
    public T get() {
        Objects.requireNonNull(this.value);
        return this.value;
    }

    public T getOrCreate() {
        if (this.value == null) {
            Objects.requireNonNull(this.factory);
            this.value = Objects.requireNonNull(this.factory.get());
            this.factory = null;
        }
        return this.get();
    }

    public void setKey(ResourceKey<T> key) {
        Objects.requireNonNull(key);
        if (this.key != null) {
            throw new IllegalStateException("Key already set: " + String.valueOf(this.key) + " -> " + String.valueOf(key));
        }
        this.key = key;
    }

    public boolean is(Object value) {
        if (this.key == null) {
            return false;
        }
        return Objects.equals(this.value, value);
    }

    public boolean is(ItemStack stack) {
        if (this.key == null || stack.isEmpty()) {
            return false;
        }
        return stack.is(((ItemLike)this.get()).asItem());
    }

    public boolean is(BlockState state) {
        if (this.key == null) {
            return false;
        }
        return state.is((Block)this.get());
    }

    public BlockState defaultBlockState() {
        return ((Block)this.get()).defaultBlockState();
    }

    public ItemStack itemStack() {
        return this.itemStack(1);
    }

    public ItemStack itemStack(int amount) {
        ItemStack stack = ((ItemLike)this.get()).asItem().getDefaultInstance();
        if (!stack.isEmpty()) {
            stack.setCount(amount);
        }
        return stack;
    }

    public ResourceLocation key() {
        return this.resourceKey().location();
    }

    public ResourceKey<T> resourceKey() {
        return Objects.requireNonNull(this.key);
    }

    @Nullable
    public Field field() {
        return this.field;
    }

    @Nullable
    public GroupSetting groupSetting() {
        return this.groupSetting;
    }

    void register() {
        Registry registry = Objects.requireNonNull((Registry)BuiltInRegistries.REGISTRY.get(this.resourceKey().registry()));
        Registry.register((Registry)registry, (ResourceLocation)this.key(), this.get());
    }

    @Nullable
    public ResourceKey<? extends Registry<?>> findRegistry() {
        return Kiwi.registryLookup.findRegistry(this.get());
    }

    public Optional<? extends Holder<T>> holder() {
        if (this.key == null) {
            return Optional.empty();
        }
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(this.key.registry());
        if (registry == null) {
            return Optional.empty();
        }
        return registry.getHolder(this.key);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", this.key).append("value", this.value).append("field", (Object)this.field).append("groupSetting", (Object)this.groupSetting).toString();
    }

    public static class Ref<T>
    extends KiwiGO<T> {
        final ResourceKey<? extends Registry<?>> registryKey;

        public Ref(ResourceKey<? extends Registry<?>> registryKey) {
            super(null);
            this.registryKey = registryKey;
        }

        @Override
        public ResourceKey<? extends Registry<?>> findRegistry() {
            return this.registryKey;
        }

        @Override
        public T get() {
            if (this.value == null) {
                Registry registry = Objects.requireNonNull((Registry)BuiltInRegistries.REGISTRY.get(this.resourceKey().registry()));
                this.value = registry.getOrThrow(this.resourceKey());
            }
            return (T)this.value;
        }

        @Override
        public T getOrCreate() {
            return this.get();
        }
    }

    public static class Direct<T>
    extends KiwiGO<T> {
        public Direct(T value) {
            super(null);
            this.value = value;
        }
    }

    public static class RegistrySpecified<T>
    extends KiwiGO<T> {
        final ResourceKey<? extends Registry<?>> registryKey;

        public RegistrySpecified(Supplier<T> factory, ResourceKey<? extends Registry<?>> registryKey) {
            super(factory);
            this.registryKey = registryKey;
        }

        @Override
        public ResourceKey<? extends Registry<?>> findRegistry() {
            return this.registryKey;
        }
    }
}

