/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.tracking.FoodInstance;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public final class FoodList
implements FoodCapability {
    private static final String NBT_KEY_FOOD_LIST = "foodList";
    private final Set<FoodInstance> foods = new HashSet<FoodInstance>();
    @Nullable
    private ProgressInfo cachedProgressInfo;

    public static FoodList get(Player player) {
        return (FoodList)player.getData(SOLCarrot.FOOD_ATTACHMENT);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.foods.stream().map(FoodInstance::encode).filter(Objects::nonNull).map(StringTag::valueOf).forEach(arg_0 -> list.add(arg_0));
        tag.put(NBT_KEY_FOOD_LIST, (Tag)list);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        ListTag list = tag.getList(NBT_KEY_FOOD_LIST, 8);
        this.foods.clear();
        list.stream().map(nbt -> (StringTag)nbt).map(StringTag::getAsString).map(FoodInstance::decode).filter(Objects::nonNull).forEach(this.foods::add);
        this.invalidateProgressInfo();
    }

    public boolean addFood(ItemStack food) {
        boolean wasAdded = this.foods.add(new FoodInstance(food.getItem())) && SOLCarrotConfig.shouldCount(food);
        this.invalidateProgressInfo();
        return wasAdded;
    }

    @Override
    public boolean hasEaten(Item food) {
        return this.hasEaten(food.getDefaultInstance());
    }

    @Override
    public boolean hasEaten(ItemStack food) {
        if (food.getFoodProperties(null) == null) {
            return false;
        }
        return this.foods.contains(new FoodInstance(food.getItem()));
    }

    public void clearFood() {
        this.foods.clear();
        this.invalidateProgressInfo();
    }

    public Set<FoodInstance> getEatenFoods() {
        return new HashSet<FoodInstance>(this.foods);
    }

    @Override
    public int getEatenFoodCount() {
        return this.foods.size();
    }

    public ProgressInfo getProgressInfo() {
        if (this.cachedProgressInfo == null) {
            this.cachedProgressInfo = new ProgressInfo(this);
        }
        return this.cachedProgressInfo;
    }

    public void invalidateProgressInfo() {
        this.cachedProgressInfo = null;
    }

    public static class FoodListNotFoundException
    extends RuntimeException {
        public FoodListNotFoundException() {
            super("Player must have food capability attached, but none was found.");
        }
    }
}

