/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.communication.handler;

import com.cazsius.solcarrot.client.FoodItems;
import com.cazsius.solcarrot.communication.ConstructFoodsMessage;
import com.cazsius.solcarrot.communication.FoodListMessage;
import com.cazsius.solcarrot.tracking.FoodList;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleFoodList(FoodListMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player != null) {
                FoodList.get(player).deserializeNBT((HolderLookup.Provider)player.registryAccess(), message.capabilityNBT());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"solcarrot.networking.food_list_message.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleConstructFoods(ConstructFoodsMessage message, IPayloadContext context) {
        context.enqueueWork(FoodItems::setUp).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"solcarrot.networking.construct_foods_message.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

