/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.ItemUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.schematic.nbt.PartialSafeNBT;
import com.simibubi.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.IMergeableBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ICopycatBlockEntity
extends SpecialBlockEntityItemRequirement,
TransformableBlockEntity,
PartialSafeNBT,
IMergeableBE {
    public void notifyUpdate();

    public Level getLevel();

    public BlockPos getBlockPos();

    public BlockState getBlockState();

    public HolderGetter<Block> blockHolderGetter();

    public void setBlockState(BlockState var1);

    public void setLevel(Level var1);

    public BlockState getMaterial();

    public ItemStack getConsumedItem();

    public boolean isCTEnabled();

    @ApiStatus.OverrideOnly
    public void setMaterialInternal(BlockState var1);

    @ApiStatus.OverrideOnly
    public void setConsumedItemInternal(ItemStack var1);

    @ApiStatus.OverrideOnly
    public void setCTEnabledInternal(boolean var1);

    default public void init() {
        this.setMaterialInternal(AllBlocks.COPYCAT_BASE.getDefaultState());
        this.setConsumedItemInternal(ItemStack.EMPTY);
        this.setCTEnabledInternal(true);
    }

    default public void onLoad() {
        BlockEntityUtils.updateLight((BlockEntity)this);
    }

    default public ICopycatBlock getBlock() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof ICopycatBlock) {
            ICopycatBlock copycatBlock = (ICopycatBlock)block;
            return copycatBlock;
        }
        return new ICopycatBlock(this){};
    }

    default public boolean hasCustomMaterial() {
        return !AllBlocks.COPYCAT_BASE.has(this.getMaterial());
    }

    default public void setMaterial(BlockState blockState) {
        BlockState wrapperState = this.getBlockState();
        if (!this.getMaterial().is(blockState.getBlock())) {
            for (Direction side : Iterate.directions) {
                ICopycatBlockEntity cbe;
                BlockState otherMaterial;
                BlockEntity blockEntity;
                BlockPos neighbour = this.getBlockPos().relative(side);
                BlockState neighbourState = this.getLevel().getBlockState(neighbour);
                if (neighbourState != wrapperState || !((blockEntity = this.getLevel().getBlockEntity(neighbour)) instanceof ICopycatBlockEntity) || !(otherMaterial = (cbe = (ICopycatBlockEntity)blockEntity).getMaterial()).is(blockState.getBlock())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        this.setMaterialInternal(blockState);
        BlockEntityUtils.redraw((BlockEntity)this);
    }

    default public boolean cycleMaterial() {
        BlockState material = this.getMaterial();
        if (material.hasProperty((Property)TrapDoorBlock.HALF) && material.getOptionalValue((Property)TrapDoorBlock.OPEN).orElse(false).booleanValue()) {
            this.setMaterial((BlockState)material.cycle((Property)TrapDoorBlock.HALF));
        } else if (material.hasProperty((Property)BlockStateProperties.FACING)) {
            this.setMaterial((BlockState)material.cycle((Property)BlockStateProperties.FACING));
        } else if (material.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            this.setMaterial((BlockState)material.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)material.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise()));
        } else if (material.hasProperty((Property)BlockStateProperties.AXIS)) {
            this.setMaterial((BlockState)material.cycle((Property)BlockStateProperties.AXIS));
        } else if (material.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            this.setMaterial((BlockState)material.cycle((Property)BlockStateProperties.HORIZONTAL_AXIS));
        } else if (material.hasProperty((Property)BlockStateProperties.LIT)) {
            this.setMaterial((BlockState)material.cycle((Property)BlockStateProperties.LIT));
        } else if (material.hasProperty((Property)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial((BlockState)material.cycle((Property)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    default public void setConsumedItem(ItemStack stack) {
        this.setConsumedItemInternal(ItemUtils.copyStackWithSize(stack, 1));
        this.notifyUpdate();
    }

    default public void setCTEnabled(boolean value) {
        this.setCTEnabledInternal(value);
        this.notifyUpdate();
    }

    default public ItemRequirement getRequiredItems(BlockState state) {
        if (this.getConsumedItem().isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.getConsumedItem());
    }

    default public void accept(BlockEntity other) {
        if (other instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity be = (ICopycatBlockEntity)other;
            this.setMaterial(be.getMaterial());
            this.setConsumedItem(be.getConsumedItem());
            this.setCTEnabled(be.isCTEnabled());
            BlockEntityUtils.redraw((BlockEntity)this);
        }
    }

    default public void transform(BlockEntity blockEntity, StructureTransform transform) {
        this.setMaterialInternal(transform.apply(this.getMaterial()));
        this.notifyUpdate();
    }

    public static void read(ICopycatBlockEntity self, CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (tag.contains("EnableCT")) {
            self.setCTEnabled(tag.getBoolean("EnableCT"));
        } else {
            self.setCTEnabled(true);
        }
        self.setConsumedItem(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Item")));
        BlockState prevMaterial = self.getMaterial();
        if (!tag.contains("Material")) {
            self.setConsumedItem(ItemStack.EMPTY);
            return;
        }
        self.setMaterialInternal(NbtUtils.readBlockState(self.blockHolderGetter(), (CompoundTag)tag.getCompound("Material")));
        if (self.getMaterial() != null && !clientPacket) {
            BlockState blockState = self.getBlockState();
            if (blockState == null) {
                return;
            }
            Block block = blockState.getBlock();
            if (!(block instanceof ICopycatBlock)) {
                return;
            }
            ICopycatBlock cb = (ICopycatBlock)block;
            BlockState acceptedBlockState = cb.getAcceptedBlockState(self.getLevel(), self.getBlockPos(), self.getConsumedItem(), null);
            if (acceptedBlockState != null && self.getMaterial().is(acceptedBlockState.getBlock())) {
                return;
            }
            self.setConsumedItem(ItemStack.EMPTY);
            self.setMaterialInternal(AllBlocks.COPYCAT_BASE.getDefaultState());
        }
        if (prevMaterial != self.getMaterial()) {
            BlockEntityUtils.redraw((BlockEntity)self);
        }
    }

    public static void writeSafe(ICopycatBlockEntity self, CompoundTag tag, HolderLookup.Provider registries) {
        ItemStack stackWithoutNBT = self.getConsumedItem().copy();
        ItemStack stackWithoutComponents = new ItemStack(stackWithoutNBT.getItemHolder(), stackWithoutNBT.getCount(), DataComponentPatch.EMPTY);
        BlockEntityUtils.saveMetadata((BlockEntity)self, tag);
        ICopycatBlockEntity.write(tag, stackWithoutComponents, self.getMaterial(), registries, self.isCTEnabled());
    }

    public static void write(ICopycatBlockEntity self, CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        ICopycatBlockEntity.write(tag, self.getConsumedItem(), self.getMaterial(), registries, self.isCTEnabled());
    }

    @ApiStatus.Internal
    public static void write(CompoundTag tag, ItemStack stack, BlockState material, HolderLookup.Provider registries, boolean enableCT) {
        tag.put("Item", ItemUtils.serializeNBT(stack, registries));
        tag.put("Material", (Tag)NbtUtils.writeBlockState((BlockState)material));
        tag.putBoolean("EnableCT", enableCT);
    }
}

