/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;

public class MechanicalConduitEffect {
    private float ticks = 0.0f;
    private int amplifier = 0;
    private final String langKey;
    private final Holder<MobEffect> effect;
    private final int hexColor;
    private final TagKey fluidTag;

    public MechanicalConduitEffect(String langKey, Holder<MobEffect> effect, int hexColor, TagKey fluidTag) {
        this.langKey = langKey;
        this.effect = effect;
        this.hexColor = hexColor;
        this.fluidTag = fluidTag;
    }

    public int getTicks() {
        return Mth.floor((float)this.ticks);
    }

    public void setTicks(int newTicks) {
        this.ticks = newTicks;
    }

    public boolean isActive() {
        return this.ticks > 0.0f;
    }

    public void addTicks(float amount) {
        this.ticks += amount;
    }

    public void subtractTicks() {
        this.ticks -= 1.0f;
        if (this.ticks < 0.0f) {
            this.ticks = 0.0f;
        }
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public void setAmplifier(int newAmplifier) {
        if (newAmplifier > this.amplifier) {
            this.amplifier = newAmplifier;
        }
    }

    public void resetAmplifier() {
        this.amplifier = 0;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public int getColor() {
        return this.hexColor;
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public TagKey getFluidTag() {
        return this.fluidTag;
    }
}

