/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import com.simibubi.create.AllFluids;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlock;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitEffect;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitModeSlot;
import net.davio.aquaticambitions.infrastructure.config.CAAConfig;
import net.davio.aquaticambitions.registry.CAABlockEntityTypes;
import net.davio.aquaticambitions.registry.CAAIcons;
import net.davio.aquaticambitions.registry.CAATags;
import net.davio.aquaticambitions.util.CAALang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MechanicalConduitBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final int TANK_CAPACITY = 1000;
    private SmartFluidTankBehaviour tank;
    private int awakenedTicks = 0;
    private final int awakenedTicksLimit = 144000;
    Map<String, MechanicalConduitEffect> conduitEffectsMap = new HashMap<String, MechanicalConduitEffect>();
    protected LerpedFloat eyeAnimation;
    protected LerpedFloat eyeAngle;
    protected LerpedFloat cageAngle;
    protected ScrollOptionBehaviour<EntitySelectionMode> entityTypeSelector;

    public MechanicalConduitBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.conduitEffectsMap.put("CONDUIT_POWER", new MechanicalConduitEffect("effect.minecraft.conduit_power", (Holder<MobEffect>)MobEffects.CONDUIT_POWER, 1950417, CAATags.CAAFluidTags.CONDUIT_FUEL.tag));
        this.conduitEffectsMap.put("CLEAR", new MechanicalConduitEffect("tooltip.create_aquatic_ambitions.effect.cleansing", null, 0xFFFFFF, CAATags.CAAFluidTags.CLEARS_EFFECTS.tag));
        this.conduitEffectsMap.put("BURNING", new MechanicalConduitEffect("tooltip.create_aquatic_ambitions.effect.burning", null, 0xE2AA22, CAATags.CAAFluidTags.SETS_ON_FIRE.tag));
        this.conduitEffectsMap.put("SATURATION", new MechanicalConduitEffect("effect.minecraft.saturation", (Holder<MobEffect>)MobEffects.SATURATION, 16262177, CAATags.CAAFluidTags.GIVES_SATURATION.tag));
        this.conduitEffectsMap.put("FIRE_RESISTANCE", new MechanicalConduitEffect("effect.minecraft.fire_resistance", (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 14981690, CAATags.CAAFluidTags.GIVES_FIRE_RES.tag));
        this.conduitEffectsMap.put("HASTE", new MechanicalConduitEffect("effect.minecraft.haste", (Holder<MobEffect>)MobEffects.DIG_SPEED, 14270531, CAATags.CAAFluidTags.GIVES_HASTE.tag));
        this.conduitEffectsMap.put("INFESTED", new MechanicalConduitEffect("effect.minecraft.infested", (Holder<MobEffect>)MobEffects.INFESTED, 9214860, CAATags.CAAFluidTags.GIVES_INFESTED.tag));
        this.conduitEffectsMap.put("INVISIBILITY", new MechanicalConduitEffect("effect.minecraft.invisibility", (Holder<MobEffect>)MobEffects.INVISIBILITY, 8356754, CAATags.CAAFluidTags.GIVES_INVIS.tag));
        this.conduitEffectsMap.put("JUMP_BOOST", new MechanicalConduitEffect("effect.minecraft.jump_boost", (Holder<MobEffect>)MobEffects.JUMP, 2358349, CAATags.CAAFluidTags.GIVES_JUMP.tag));
        this.conduitEffectsMap.put("LUCK", new MechanicalConduitEffect("effect.minecraft.luck", (Holder<MobEffect>)MobEffects.LUCK, 0x339900, CAATags.CAAFluidTags.GIVES_LUCK.tag));
        this.conduitEffectsMap.put("NIGHT_VISION", new MechanicalConduitEffect("effect.minecraft.night_vision", (Holder<MobEffect>)MobEffects.NIGHT_VISION, 0x1F1FA1, CAATags.CAAFluidTags.GIVES_NIGHT_VISION.tag));
        this.conduitEffectsMap.put("OOZING", new MechanicalConduitEffect("effect.minecraft.oozing", (Holder<MobEffect>)MobEffects.OOZING, 10092451, CAATags.CAAFluidTags.GIVES_OOZING.tag));
        this.conduitEffectsMap.put("POISON", new MechanicalConduitEffect("effect.minecraft.poison", (Holder<MobEffect>)MobEffects.POISON, 5149489, CAATags.CAAFluidTags.GIVES_POISON.tag));
        this.conduitEffectsMap.put("REGENERATION", new MechanicalConduitEffect("effect.minecraft.regeneration", (Holder<MobEffect>)MobEffects.REGENERATION, 13458603, CAATags.CAAFluidTags.GIVES_REGEN.tag));
        this.conduitEffectsMap.put("RESISTANCE", new MechanicalConduitEffect("effect.minecraft.resistance", (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 9389549, CAATags.CAAFluidTags.GIVES_RESISTANCE.tag));
        this.conduitEffectsMap.put("SLOW_FALLING", new MechanicalConduitEffect("effect.minecraft.slow_falling", (Holder<MobEffect>)MobEffects.SLOW_FALLING, 16773073, CAATags.CAAFluidTags.GIVES_SLOW_FALL.tag));
        this.conduitEffectsMap.put("SLOWNESS", new MechanicalConduitEffect("effect.minecraft.slowness", (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 5926017, CAATags.CAAFluidTags.GIVES_SLOWNESS.tag));
        this.conduitEffectsMap.put("SPEED", new MechanicalConduitEffect("effect.minecraft.speed", (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 8171462, CAATags.CAAFluidTags.GIVES_SPEED.tag));
        this.conduitEffectsMap.put("STRENGTH", new MechanicalConduitEffect("effect.minecraft.strength", (Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 16565504, CAATags.CAAFluidTags.GIVES_STRENGTH.tag));
        this.conduitEffectsMap.put("WATER_BREATHING", new MechanicalConduitEffect("effect.minecraft.water_breathing", (Holder<MobEffect>)MobEffects.WATER_BREATHING, 9885630, CAATags.CAAFluidTags.GIVES_WATER_BREATHING.tag));
        this.conduitEffectsMap.put("WEAKNESS", new MechanicalConduitEffect("effect.minecraft.weakness", (Holder<MobEffect>)MobEffects.WEAKNESS, 0x484D48, CAATags.CAAFluidTags.GIVES_WEAKNESS.tag));
        this.conduitEffectsMap.put("WEAVING", new MechanicalConduitEffect("effect.minecraft.weaving", (Holder<MobEffect>)MobEffects.WEAVING, 7891290, CAATags.CAAFluidTags.GIVES_WEAVING.tag));
        this.conduitEffectsMap.put("WIND_CHARGED", new MechanicalConduitEffect("effect.minecraft.wind_charged", (Holder<MobEffect>)MobEffects.WIND_CHARGED, 12438015, CAATags.CAAFluidTags.GIVES_WIND.tag));
        this.conduitEffectsMap.put("WITHER", new MechanicalConduitEffect("effect.minecraft.wither", (Holder<MobEffect>)MobEffects.WITHER, 3484199, CAATags.CAAFluidTags.GIVES_WITHER.tag));
        this.eyeAnimation = LerpedFloat.linear();
        this.eyeAngle = LerpedFloat.angular();
        this.cageAngle = LerpedFloat.angular();
        this.eyeAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)Direction.NORTH) + 180.0f) % 360.0f));
        this.cageAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)Direction.NORTH) + 180.0f) % 360.0f));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(this::consumeFluid).forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.entityTypeSelector = new ScrollOptionBehaviour(EntitySelectionMode.class, (Component)CAALang.translateDirect("mechanical_conduit.entity_filter.title", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MechanicalConduitModeSlot());
        behaviours.add((BlockEntityBehaviour)this.entityTypeSelector);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CAABlockEntityTypes.MECHANICAL_CONDUIT.get(), (be, context) -> {
            if (context == null || context == Direction.DOWN) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    private void consumeFluid() {
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluid();
        for (MechanicalConduitEffect conduitEffect : this.conduitEffectsMap.values()) {
            if (fluidStack.is(conduitEffect.getFluidTag()) || this.potionHasEffect(fluidStack, conduitEffect)) {
                conduitEffect.addTicks(this.getConversionRate(fluidStack) * (float)fluidStack.getAmount());
            }
            if (conduitEffect.getTicks() <= 144000) continue;
            this.tank.forbidInsertion();
        }
        this.tank.getPrimaryHandler().drain(1000, IFluidHandler.FluidAction.EXECUTE);
        this.notifyUpdate();
        this.updateBlockState();
        this.sendData();
    }

    private boolean potionHasEffect(FluidStack fluidStack, MechanicalConduitEffect conduitEffect) {
        PotionContents potionContents = (PotionContents)fluidStack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return false;
        }
        for (MobEffectInstance effect : potionContents.getAllEffects()) {
            if (!effect.is(conduitEffect.getEffect())) continue;
            conduitEffect.setAmplifier(effect.getAmplifier());
            return true;
        }
        return false;
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            if (this.shouldTickAnimation()) {
                this.tickAnimation();
            }
            if (!this.isVirtual()) {
                this.spawnParticles(this.getConduitLevelFromBlock());
            }
            return;
        }
        int maxAwakanedTicks = 0;
        for (MechanicalConduitEffect conduitEffect : this.conduitEffectsMap.values()) {
            if (conduitEffect.isActive()) {
                conduitEffect.subtractTicks();
                if (conduitEffect.getFluidTag() == CAATags.CAAFluidTags.CLEARS_EFFECTS.tag) {
                    this.clearEffects();
                } else if (conduitEffect.getFluidTag() == CAATags.CAAFluidTags.SETS_ON_FIRE.tag) {
                    this.setOnFire();
                } else {
                    this.applyEffects(conduitEffect.getEffect(), conduitEffect.getAmplifier());
                }
                if (conduitEffect.getTicks() < 144000) {
                    this.tank.allowInsertion();
                }
                if (conduitEffect.getTicks() > maxAwakanedTicks) {
                    maxAwakanedTicks = conduitEffect.getTicks();
                }
            } else if (conduitEffect.getAmplifier() > 0) {
                conduitEffect.resetAmplifier();
            }
            this.awakenedTicks = maxAwakanedTicks;
        }
        this.updateBlockState();
        this.sendData();
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("awakenedTimeRemaining", this.awakenedTicks);
        CompoundTag effectsTag = new CompoundTag();
        for (Map.Entry<String, MechanicalConduitEffect> entry : this.conduitEffectsMap.entrySet()) {
            effectsTag.putInt(entry.getKey(), entry.getValue().getTicks());
        }
        compound.put("ConduitEffects", (Tag)effectsTag);
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.awakenedTicks = compound.getInt("awakenedTimeRemaining");
        super.read(compound, registries, clientPacket);
        CompoundTag effectsTag = compound.getCompound("ConduitEffects");
        for (String key : effectsTag.getAllKeys()) {
            MechanicalConduitEffect effect = this.conduitEffectsMap.get(key);
            if (effect == null) continue;
            effect.setTicks(effectsTag.getInt(key));
        }
    }

    public MechanicalConduitBlock.ConduitPowerLevel getConduitLevelFromBlock() {
        return MechanicalConduitBlock.getConduitLevelOf(this.getBlockState());
    }

    public void updateBlockState() {
        this.setConduitLevelOfBlock(this.getConduitLevel());
    }

    public void setConduitLevelOfBlock(MechanicalConduitBlock.ConduitPowerLevel conduitPowerLevel) {
        MechanicalConduitBlock.ConduitPowerLevel inBlockState = this.getConduitLevelFromBlock();
        if (inBlockState == conduitPowerLevel) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MechanicalConduitBlock.CONDUIT_POWER_LEVEL, (Comparable)((Object)conduitPowerLevel)));
        this.notifyUpdate();
    }

    protected MechanicalConduitBlock.ConduitPowerLevel getConduitLevel() {
        if (this.awakenedTicks > 0) {
            return MechanicalConduitBlock.ConduitPowerLevel.AWAKENED;
        }
        return MechanicalConduitBlock.ConduitPowerLevel.IDLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean shouldTickAnimation() {
        return !VisualizationManager.supportsVisualization((LevelAccessor)this.level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAnimation() {
        float eyeTarget = 0.0f;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !player.isInvisible()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.getX();
                z = player.getZ();
            }
            double dx = x - ((double)this.getBlockPos().getX() + 0.5);
            double dz = z - ((double)this.getBlockPos().getZ() + 0.5);
            eyeTarget = AngleHelper.deg((double)(-Mth.atan2((double)dz, (double)dx))) - 90.0f;
        }
        eyeTarget = this.eyeAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.eyeAngle.getValue(), (double)eyeTarget);
        this.eyeAngle.chase((double)eyeTarget, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.eyeAngle.tickChaser();
        this.eyeAnimation.chase(0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.eyeAnimation.tickChaser();
    }

    protected void spawnParticles(MechanicalConduitBlock.ConduitPowerLevel conduitPowerLevel) {
        if (this.level == null) {
            return;
        }
        if (conduitPowerLevel == MechanicalConduitBlock.ConduitPowerLevel.IDLE) {
            return;
        }
        RandomSource r = this.level.getRandom();
        if (conduitPowerLevel.isAwakened() && r.nextInt(5) == 0) {
            Vec3 vec31 = new Vec3((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 2.0f), (double)((float)this.getBlockPos().getZ() + 0.5f));
            float f3 = (-0.5f + r.nextFloat()) * 2.0f;
            float f4 = -1.25f + r.nextFloat();
            float f5 = (-0.5f + r.nextFloat()) * 2.0f;
            Vec3 vec32 = new Vec3((double)f3, (double)f4, (double)f5);
            this.level.addParticle((ParticleOptions)ParticleTypes.NAUTILUS, vec31.x, vec31.y, vec31.z, vec32.x, vec32.y, vec32.z);
        }
    }

    private void applyEffects(Holder<MobEffect> effect, int amplifier) {
        int range = (Integer)CAAConfig.server().conduitCage.conduitCageRange.get();
        List<LivingEntity> list = this.getLivingEntities(range);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                MobEffectInstance existing;
                if (!MechanicalConduitBlockEntity.entityMatchesSelector(entity, (EntitySelectionMode)this.entityTypeSelector.get()) || !this.getBlockPos().closerThan((Vec3i)entity.blockPosition(), (double)range) || (existing = entity.getEffect(effect)) != null && existing.getDuration() >= 25) continue;
                entity.addEffect(new MobEffectInstance(effect, 119, amplifier, true, true));
            }
        }
    }

    private void clearEffects() {
        int range = (Integer)CAAConfig.server().conduitCage.conduitCageRange.get();
        List<LivingEntity> list = this.getLivingEntities(range);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (!MechanicalConduitBlockEntity.entityMatchesSelector(entity, (EntitySelectionMode)this.entityTypeSelector.get()) || !this.getBlockPos().closerThan((Vec3i)entity.blockPosition(), (double)range)) continue;
                entity.removeAllEffects();
            }
        }
    }

    private void setOnFire() {
        int range = (Integer)CAAConfig.server().conduitCage.conduitCageRange.get();
        List<LivingEntity> list = this.getLivingEntities(range);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (!MechanicalConduitBlockEntity.entityMatchesSelector(entity, (EntitySelectionMode)this.entityTypeSelector.get()) || !this.getBlockPos().closerThan((Vec3i)entity.blockPosition(), (double)range)) continue;
                entity.setRemainingFireTicks(100);
            }
        }
    }

    public List<LivingEntity> getLivingEntities(int range) {
        int k = this.getBlockPos().getX();
        int l = this.getBlockPos().getY();
        int i1 = this.getBlockPos().getZ();
        AABB aabb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).inflate((double)range).expandTowards(0.0, (double)this.level.getHeight(), 0.0);
        List list = this.level.getEntitiesOfClass(LivingEntity.class, aabb);
        return list;
    }

    public float getConversionRate(FluidStack fluidStack) {
        float conversionRate = CAATags.CAAFluidTags.CONDUIT_FUEL.matches(fluidStack.getFluid()) ? (float)((Integer)CAAConfig.server().conduitCage.waterAwakenConversionRate.get() * 20) / 1000.0f : (fluidStack.getFluid().isSame((Fluid)AllFluids.POTION.get()) ? (float)((Integer)CAAConfig.server().conduitCage.potionAwakenConversionRate.get() * 20) / 1000.0f : (float)((Integer)CAAConfig.server().conduitCage.fluidAwakenConversionRate.get() * 20) / 1000.0f);
        return conversionRate;
    }

    public static boolean entityMatchesSelector(LivingEntity entity, EntitySelectionMode mode) {
        if (mode == EntitySelectionMode.PLAYERS) {
            return entity instanceof Player;
        }
        if (mode == EntitySelectionMode.MONSTERS) {
            return entity instanceof Enemy;
        }
        if (mode == EntitySelectionMode.FRIENDLY_MOBS) {
            return entity instanceof PathfinderMob && !(entity instanceof Monster);
        }
        if (mode == EntitySelectionMode.PLAYERS_FRIENDLY_MOBS) {
            return entity instanceof PathfinderMob && !(entity instanceof Monster) || entity instanceof Player;
        }
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.getConduitLevel().isAwakened()) {
            return false;
        }
        CAALang.translate("tooltip.conduitcage.header", new Object[0]).forGoggles(tooltip);
        for (MechanicalConduitEffect conduitEffect : this.conduitEffectsMap.values()) {
            MutableComponent effectName = Component.translatable((String)conduitEffect.getLangKey()).withStyle(Style.EMPTY.withColor(conduitEffect.getColor()));
            if (!conduitEffect.isActive()) continue;
            CAALang.text("").add((Component)effectName).add(CAALang.text(" ")).add(CAALang.text(this.tickToDuration(conduitEffect.getTicks())).style(ChatFormatting.WHITE)).forGoggles(tooltip, 1);
        }
        return true;
    }

    public String tickToDuration(int tickAmount) {
        if (tickAmount > 143990) {
            return "\u221e";
        }
        int totalSeconds = tickAmount / 20;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds / 60 % 60;
        int seconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static enum EntitySelectionMode implements INamedIconOptions
    {
        EVERYONE(CAAIcons.I_EVERYONE),
        PLAYERS(CAAIcons.I_PLAYERS),
        FRIENDLY_MOBS(CAAIcons.I_FRIENDLY_MOBS),
        PLAYERS_FRIENDLY_MOBS(CAAIcons.I_PLAYERS_FRIENDLY_MOBS),
        MONSTERS(CAAIcons.I_MONSTERS);

        private final String translationKey;
        private final CAAIcons icon;

        private EntitySelectionMode(CAAIcons icon) {
            this.icon = icon;
            this.translationKey = "mechanical_conduit.selection_mode." + Lang.asId((String)this.name());
        }

        public CAAIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

