/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.data.Chimney;
import io.github.mortuusars.sootychimneys.recipe.result.ChanceResult;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SootScrapingRecipe(Ingredient chimney, List<ChanceResult> results) implements Recipe<SingleRecipeInput>
{
    public static final int MAX_RESULTS = 6;

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultChimney() {
        for (ItemStack item : this.chimney.getItems()) {
            ChimneyBlock chimneyBlock;
            BlockItem blockItem;
            Item item2 = item.getItem();
            if (!(item2 instanceof BlockItem) || !((item2 = (blockItem = (BlockItem)item2).getBlock()) instanceof ChimneyBlock) || !(chimneyBlock = (ChimneyBlock)item2).isDirty()) continue;
            Item cleanItem = Chimney.getCleanBlock(chimneyBlock).asItem();
            return new ItemStack((ItemLike)cleanItem);
        }
        return new ItemStack((ItemLike)Items.BARRIER);
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.chimney);
        return nonnulllist;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.chimney().test(input.getItem(0));
    }

    @NotNull
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.getResultChimney();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.results.getFirst().stack();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SootyChimneys.RecipeSerializers.SOOT_SCRAPING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return SootyChimneys.RecipeTypes.SOOT_SCRAPING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SootScrapingRecipe> {
        public static final MapCodec<SootScrapingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("chimney").forGetter(SootScrapingRecipe::chimney), (App)ChanceResult.CODEC.listOf(0, 3).validate(list -> list.size() <= 6 ? DataResult.success((Object)list) : DataResult.error(() -> "SootScrapingRecipe should have at most 6 results.")).fieldOf("results").forGetter(SootScrapingRecipe::results)).apply((Applicative)instance, SootScrapingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SootScrapingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SootScrapingRecipe::chimney, (StreamCodec)ChanceResult.STREAM_CODEC.apply(ByteBufCodecs.list((int)6)), SootScrapingRecipe::results, SootScrapingRecipe::new);

        @NotNull
        public MapCodec<SootScrapingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SootScrapingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

