/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.category;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.data.smoke.SmokeProperties;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.drawable.ChimneySmokeAnimatedDrawable;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootCoveringJeiRecipe;
import io.github.mortuusars.sootychimneys.integration.jei.renderer.ScalableItemStackRenderer;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SootCoveringRecipeCategory
implements IRecipeCategory<SootCoveringJeiRecipe> {
    public static final int BG_WIDTH = 153;
    public static final int BG_HEIGHT = 65;
    public static final Map<Item, Integer> CHIMNEY_SMOKE_Y_ORIGIN = new HashMap<Item, Integer>(){
        {
            this.put((Item)SootyChimneys.Items.BRICK_CHIMNEY.get(), 3);
            this.put((Item)SootyChimneys.Items.DIRTY_BRICK_CHIMNEY.get(), 3);
            this.put((Item)SootyChimneys.Items.COBBLESTONE_CHIMNEY.get(), 3);
            this.put((Item)SootyChimneys.Items.DIRTY_COBBLESTONE_CHIMNEY.get(), 3);
            this.put((Item)SootyChimneys.Items.STONE_BRICK_CHIMNEY.get(), 0);
            this.put((Item)SootyChimneys.Items.DIRTY_STONE_BRICK_CHIMNEY.get(), 0);
            this.put((Item)SootyChimneys.Items.MUD_BRICK_CHIMNEY.get(), 3);
            this.put((Item)SootyChimneys.Items.DIRTY_MUD_BRICK_CHIMNEY.get(), 3);
            this.put((Item)SootyChimneys.Items.IRON_CHIMNEY.get(), 2);
            this.put((Item)SootyChimneys.Items.DIRTY_IRON_CHIMNEY.get(), 2);
            this.put((Item)SootyChimneys.Items.COPPER_CHIMNEY.get(), -1);
            this.put((Item)SootyChimneys.Items.DIRTY_COPPER_CHIMNEY.get(), -1);
            this.put((Item)SootyChimneys.Items.TERRACOTTA_CHIMNEY.get(), 10);
            this.put((Item)SootyChimneys.Items.DIRTY_TERRACOTTA_CHIMNEY.get(), 10);
        }
    };
    private final Component title;
    private final IDrawable background;
    private final IDrawableStatic icon;
    private final IGuiHelper helper;

    public SootCoveringRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.title = Component.translatable((String)"jei.sootychimneys.category.soot_covering");
        ResourceLocation texture = SootyChimneys.resource("textures/gui/jei/soot_covering.png");
        this.background = helper.createDrawable(texture, 0, 0, 153, 65);
        this.icon = helper.drawableBuilder(SootyChimneys.resource("textures/gui/jei/soot_covering_icon.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull SootCoveringJeiRecipe recipe, @NotNull IFocusGroup focuses) {
        ChimneySmokeAnimatedDrawable ingredientSmoke = this.createSmokeDrawable(recipe.getCleanChimney());
        Integer yOffset = CHIMNEY_SMOKE_Y_ORIGIN.get(recipe.getCleanChimney().getItem());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).setOverlay((IDrawable)ingredientSmoke, 12, yOffset.intValue()).addItemStack(recipe.getCleanChimney())).setSlotName("CleanChimney");
        ChimneySmokeAnimatedDrawable resultSmoke = this.createSmokeDrawable(recipe.getDirtyChimney());
        Integer yOffset1 = CHIMNEY_SMOKE_Y_ORIGIN.get(recipe.getDirtyChimney().getItem());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).setOverlay((IDrawable)resultSmoke, 12, yOffset1.intValue()).addItemStack(recipe.getDirtyChimney())).setSlotName("DirtyChimney");
    }

    private ChimneySmokeAnimatedDrawable createSmokeDrawable(ItemStack chimney) {
        BlockItem blockItem;
        ChimneySmokeAnimatedDrawable drawable = new ChimneySmokeAnimatedDrawable(this.helper);
        Item item = chimney.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ChimneyBlock) {
            ChimneyBlock chimneyBlock = (ChimneyBlock)item;
            SmokeProperties smokeProperties = chimneyBlock.getType().smokeProperties();
            drawable.setSpeed(smokeProperties.getSpeed());
            drawable.setIntensity(smokeProperties.getIntensity());
        }
        return drawable;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<SootCoveringJeiRecipe> getRecipeType() {
        return JeiRecipeTypes.SOOT_COVERING;
    }
}

