/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.block;

import io.github.mortuusars.sootychimneys.Config;
import io.github.mortuusars.sootychimneys.PlatformSpecific;
import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlockEntity;
import io.github.mortuusars.sootychimneys.data.Chimney;
import io.github.mortuusars.sootychimneys.data.ChimneyType;
import io.github.mortuusars.sootychimneys.data.smoke.ParticleOrigin;
import io.github.mortuusars.sootychimneys.data.smoke.ParticleSpread;
import io.github.mortuusars.sootychimneys.data.smoke.SmokeProperties;
import io.github.mortuusars.sootychimneys.data.wind.Wind;
import io.github.mortuusars.sootychimneys.data.wind.WindData;
import io.github.mortuusars.sootychimneys.recipe.SootScrapingRecipe;
import io.github.mortuusars.sootychimneys.recipe.result.ChanceResult;
import io.github.mortuusars.sootychimneys.utils.RandomOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChimneyBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty BLOCKED = BooleanProperty.create((String)"blocked");
    public static final BooleanProperty STACKED = BooleanProperty.create((String)"stacked");
    protected final ChimneyType type;
    protected final Chimney.State state;

    public ChimneyBlock(BlockBehaviour.Properties properties, Chimney.State state, ChimneyType type) {
        super(properties);
        this.state = state;
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)BLOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)STACKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT}).add(new Property[]{BLOCKED}).add(new Property[]{STACKED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)STACKED) != false ? this.getStackedShape() : this.getRegularShape();
    }

    public Chimney.State getChimneyState() {
        return this.state;
    }

    public ChimneyType getType() {
        return this.type;
    }

    @NotNull
    public VoxelShape getRegularShape() {
        return this.getType().shape().regular();
    }

    @NotNull
    public VoxelShape getStackedShape() {
        return this.getType().shape().stacked();
    }

    public boolean isClean() {
        return this.state == Chimney.State.CLEAN;
    }

    public boolean isDirty() {
        return this.state == Chimney.State.DIRTY;
    }

    public boolean shouldEmitSmoke(BlockState blockState, Level level, BlockPos pos) {
        return (Boolean)blockState.getValue((Property)LIT) != false && (Boolean)blockState.getValue((Property)BLOCKED) == false && (Boolean)blockState.getValue((Property)STACKED) == false && !level.getBlockState(pos.above()).is(SootyChimneys.Tags.Blocks.SMOKE_BLOCKING);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean newBlockedValue;
        if (!player.getMainHandItem().isEmpty()) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        boolean bl = newBlockedValue = (Boolean)state.getValue((Property)BLOCKED) == false;
        if (!level.isClientSide && level.setBlock(pos, (BlockState)state.setValue((Property)BLOCKED, (Comparable)Boolean.valueOf(newBlockedValue)), 3)) {
            RandomSource random = level.getRandom();
            level.playSound(null, pos, newBlockedValue ? SoundEvents.LANTERN_FALL : SoundEvents.LANTERN_HIT, SoundSource.BLOCKS, 0.8f, 0.85f + random.nextFloat() * 0.05f);
            ParticleOrigin particleOrigin = this.getType().smokeProperties().getParticleOrigin();
            for (int i = 0; i < random.nextInt(5); ++i) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + particleOrigin.x()), (double)((float)pos.getY() + particleOrigin.y()) - 0.1, (double)((float)pos.getZ() + particleOrigin.z()), 1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, 0.0);
            }
            String messageTranslationKey = "message.sootychimneys." + (newBlockedValue ? "blocked" : "open");
            player.displayClientMessage((Component)Component.translatable((String)messageTranslationKey), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ChimneyBlock chimney;
        Block block = state.getBlock();
        if (!(block instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isDirty() && PlatformSpecific.canBeUsedToScrapeSoot(stack))) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
        }
        BlockState cleanBlockState = Chimney.getCleanBlock(this).withPropertiesOf(state);
        level.setBlock(pos, cleanBlockState, 3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.awardStat(SootyChimneys.Stats.SOOT_SCRAPED);
            Optional<Supplier<List<ItemStack>>> scrapingResult = this.getScrapedItems(state, serverLevel);
            scrapingResult.ifPresent(items -> {
                List itemStacks = (List)items.get();
                Vec3i faceNormal = hitResult.getDirection().getNormal();
                Vector3f itemSpawnPosition = new Vector3f((float)pos.getX() + 0.5f + (float)faceNormal.getX() * 0.65f, (float)pos.getY() + 0.6f + (float)faceNormal.getY() * 0.65f, (float)pos.getZ() + 0.5f + (float)faceNormal.getZ() * 0.65f);
                this.spawnSootScrapingItems(itemSpawnPosition, serverLevel, itemStacks);
            });
            stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
        } else {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
            chimney.spawnSootParticles(level, pos, false);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        this.updateState(state, level, pos);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        this.updateState(state, level, pos);
    }

    protected void updateState(BlockState state, Level level, BlockPos pos) {
        ChimneyBlock chimney;
        Block block;
        boolean stacked = level.getBlockState(pos.above()).getBlock() instanceof ChimneyBlock;
        if (stacked && (block = state.getBlock()) instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isDirty()) {
            state = Chimney.getCleanBlock(chimney).defaultBlockState();
            chimney.spawnSootParticles(level, pos, true);
        }
        level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(!level.hasNeighborSignal(pos)))).setValue((Property)STACKED, (Comparable)Boolean.valueOf(stacked)), 3);
    }

    public ParticleOptions getParticle(BlockState state, Level level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.getBlock() instanceof ChimneyBlock && (Boolean)stateBelow.getValue((Property)STACKED) != false || stateBelow.is(SootyChimneys.Tags.Blocks.SMOKE_BOOSTING) ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
    }

    public void emitParticle(Level level, double x, double y, double z, ParticleOptions particleType) {
        if (!level.isClientSide) {
            return;
        }
        SmokeProperties smokeProperties = this.getType().smokeProperties();
        RandomSource random = level.getRandom();
        if (random.nextFloat() > smokeProperties.getIntensity()) {
            return;
        }
        ParticleOrigin particleOffset = smokeProperties.getParticleOrigin();
        x += (double)particleOffset.x() - 0.5;
        y += (double)particleOffset.y() - 0.5;
        z += (double)particleOffset.z() - 0.5;
        WindData wind = Wind.getWind();
        float strength = wind.getAdjustedStrength();
        double xSpeed = wind.getXCoordinate() * (double)strength;
        double ySpeed = 0.05 * (double)smokeProperties.getSpeed();
        double zSpeed = wind.getYCoordinate() * (double)strength;
        xSpeed += (double)((random.nextFloat() * strength - strength / 2.0f) * 0.2f);
        zSpeed += (double)((random.nextFloat() * strength - strength / 2.0f) * 0.2f);
        ParticleSpread particleSpread = smokeProperties.getParticleSpread();
        int maxParticles = (int)(4.0f * Math.max(smokeProperties.getIntensity(), 0.5f));
        for (int i = 0; i < random.nextInt(maxParticles); ++i) {
            level.addAlwaysVisibleParticle(particleType, true, RandomOffset.offset(x, particleSpread.x()), RandomOffset.offset(y, particleSpread.y()), RandomOffset.offset(z, particleSpread.z()), xSpeed, ySpeed, zSpeed);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ChimneyBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide() && type == SootyChimneys.BlockEntityTypes.CHIMNEY.get() ? ChimneyBlockEntity::particleTick : null;
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        ChimneyBlock chimney;
        Block block = blockState.getBlock();
        return block instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isClean();
    }

    public void randomTick(BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        ChimneyBlock chimney;
        Block block = blockState.getBlock();
        if (block instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isClean() && this.shouldEmitSmoke(blockState, (Level)level, pos) && random.nextDouble() < (Double)Config.Common.DIRTY_CHANCE.get()) {
            level.setBlock(pos, Chimney.getDirtyBlock(chimney).defaultBlockState(), 3);
        }
    }

    protected Optional<Supplier<List<ItemStack>>> getScrapedItems(BlockState state, ServerLevel level) {
        SingleRecipeInput input = new SingleRecipeInput(new ItemStack((ItemLike)state.getBlock().asItem()));
        Optional recipeOptional = level.getRecipeManager().getRecipeFor(SootyChimneys.RecipeTypes.SOOT_SCRAPING.get(), (RecipeInput)input, (Level)level);
        return recipeOptional.map(recipeHolder -> () -> {
            SootScrapingRecipe recipe = (SootScrapingRecipe)recipeHolder.value();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ChanceResult result : recipe.results()) {
                ItemStack itemStack = result.rollOutput(level.getRandom());
                if (itemStack.isEmpty()) continue;
                items.add(itemStack);
            }
            return items;
        });
    }

    public void spawnSootScrapingItems(Vector3f pos, ServerLevel level, List<ItemStack> items) {
        for (ItemStack itemStack : items) {
            Containers.dropItemStack((Level)level, (double)pos.x(), (double)pos.y(), (double)pos.z(), (ItemStack)itemStack);
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (level instanceof Level) {
            ChimneyBlock chimney;
            Level lvl = (Level)level;
            Block block = state.getBlock();
            if (block instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isDirty()) {
                chimney.spawnSootParticles(lvl, pos, false);
            }
        }
    }

    public void spawnSootParticles(Level level, BlockPos pos, boolean serverSide) {
        RandomSource random = level.getRandom();
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        for (int i = 0; i < random.nextInt(12, 20); ++i) {
            if (serverSide && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, RandomOffset.offset(x, 0.8f), RandomOffset.offset(y, 0.8f), RandomOffset.offset(z, 0.8f), 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, RandomOffset.offset(x, 0.8f), RandomOffset.offset(y, 0.8f), RandomOffset.offset(z, 0.8f), 0.0, 0.0, 0.0);
        }
    }
}

