/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.version;

import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface Texter {
    public static final Component LINE_BREAK = Texter.literal("\n");
    public static final Component SPACE = Texter.literal(" ");
    public static final Component NERUINA_HEADER = Texter.withStyle(Texter.literal("[Neruina]: "), style -> style.withColor(ChatFormatting.AQUA));

    public static Component literal(String text) {
        return Component.literal((String)text);
    }

    public static Component translatable(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static Component withStyle(Component text, UnaryOperator<Style> style) {
        if (text instanceof MutableComponent) {
            MutableComponent mutableText = (MutableComponent)text;
            mutableText.withStyle(style);
        }
        return text;
    }

    public static Component concat(Component ... texts) {
        MutableComponent text = Component.empty();
        for (Component t : texts) {
            text.append(t);
        }
        return text;
    }

    public static Component concatDelimited(Component delimiter, Component ... texts) {
        MutableComponent text = Component.empty();
        for (int i = 0; i < texts.length; ++i) {
            text.append(texts[i]);
            if (texts[i].getString().isEmpty() || i == texts.length - 1) continue;
            text.append(delimiter);
        }
        return text;
    }

    public static Component pad(Component text) {
        MutableComponent padded = Component.empty();
        padded.append(LINE_BREAK);
        padded.append(text);
        padded.append(LINE_BREAK);
        return padded;
    }

    public static Component format(Component text) {
        return Texter.concat(NERUINA_HEADER, Texter.withStyle(text, style -> style.withColor(ChatFormatting.RED)));
    }
}

