/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.ItemStackCheck;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryCondition
implements Condition {
    public static final Codec<PlayerInventoryCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStackCheck.CODEC.listOf().fieldOf("has").forGetter(wearingCondition -> wearingCondition.stackChecks)).apply((Applicative)builder, PlayerInventoryCondition::new));
    private final List<ItemStackCheck> stackChecks;
    private final Map<Item, ItemStackCheck> itemItemStackCheckMap;

    public PlayerInventoryCondition(List<ItemStackCheck> stackChecks) {
        if (stackChecks.isEmpty()) {
            throw new IllegalArgumentException("No item stack checks were specified.");
        }
        this.stackChecks = stackChecks;
        this.itemItemStackCheckMap = new Object2ObjectOpenHashMap();
        for (ItemStackCheck stackCheck : stackChecks) {
            Item item = stackCheck.getItem();
            if (this.itemItemStackCheckMap.containsKey(item)) {
                throw new UnsupportedOperationException("Found another check for an already existing item.");
            }
            this.itemItemStackCheckMap.put(item.asItem(), stackCheck);
        }
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        if (conditionContext.entity() instanceof Player) {
            for (ItemStack item : ((Player)conditionContext.entity()).getInventory().items) {
                ItemStackCheck itemStackCheck;
                if (!this.itemItemStackCheckMap.containsKey(item.getItem()) || (itemStackCheck = this.itemItemStackCheckMap.get(item.getItem())).test(item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

