/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class PlantGrowthProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final MapCodec<PlantGrowthProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("minGrowth", (Object)Float.valueOf(0.0f)).forGetter(p -> Float.valueOf(p.minGrowth)), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("maxGrowth", (Object)Float.valueOf(1.0f)).forGetter(p -> Float.valueOf(p.maxGrowth))).apply((Applicative)instance, PlantGrowthProcessor::new));
    private final float minGrowth;
    private final float maxGrowth;

    public PlantGrowthProcessor(float minGrowth, float maxGrowth) {
        this.minGrowth = minGrowth;
        this.maxGrowth = maxGrowth;
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        if (block.state() == null) {
            return block;
        }
        Block block2 = block.state().getBlock();
        if (block2 instanceof CropBlock) {
            CropBlock crop = (CropBlock)block2;
            int age = Math.round((this.minGrowth + placeSettings.getRandom(pos).nextFloat() * (this.maxGrowth - this.minGrowth)) * (float)crop.getMaxAge());
            return new BlockInstance(crop.getStateForAge(age), block.nbt());
        }
        if (block.state().getBlock() instanceof StemBlock) {
            int age = Math.round((this.minGrowth + placeSettings.getRandom(pos).nextFloat() * (this.maxGrowth - this.minGrowth)) * 7.0f);
            return new BlockInstance((BlockState)block.state().setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(age)), block.nbt());
        }
        if (block.state().getBlock() instanceof NetherWartBlock) {
            int age = Math.round((this.minGrowth + placeSettings.getRandom(pos).nextFloat() * (this.maxGrowth - this.minGrowth)) * 3.0f);
            return new BlockInstance((BlockState)block.state().setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(age)), block.nbt());
        }
        return block;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FormationsStructures.PLANT_GROWTH_PROCESSOR.get();
    }
}

